/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import java.util.Set;
import java.util.function.Predicate;

class CustomFieldValueDrivenPredicate
implements Predicate<CustomFieldIndexer> {
    private final Set<String> knownNonnullFields;

    CustomFieldValueDrivenPredicate(Set<String> knownNonnullFields) {
        this.knownNonnullFields = knownNonnullFields;
    }

    @Override
    public boolean test(CustomFieldIndexer indexer) {
        return this.knownNonnullFields.contains(indexer.getField().getId()) || !this.providingNonnullCustomFields(indexer) || !this.skippingNull((FieldIndexer)indexer);
    }

    private boolean providingNonnullCustomFields(CustomFieldIndexer indexer) {
        CustomField field = indexer.getField();
        return field != null && field.getCustomFieldType().getNonNullCustomFieldProvider() != null;
    }

    private boolean skippingNull(FieldIndexer indexer) {
        return Boolean.TRUE.equals(indexer.skipsIndexingNull());
    }
}

