/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.util.profiling.Ticker;
import java.util.Optional;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeHistoryDocumentFactory
implements ChangeHistoryDocumentFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultChangeHistoryDocumentFactory.class);
    private final SearchExtractorRegistrationManager searchExtractorManager;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;

    public DefaultChangeHistoryDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager, IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager) {
        this.searchExtractorManager = searchExtractorManager;
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
    }

    private static String encodeChangedField(String changedField, String docConstant) {
        return changedField + '.' + docConstant;
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }

    private static String encodeProtocolPreservingCase(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem);
    }

    @Override
    public Optional<Document> createDocument(EntityWithVersion<ChangeHistoryGroup> changeHistoryGroupWithVersion) {
        ChangeHistoryGroup changeHistoryGroup = changeHistoryGroupWithVersion.getEntity();
        try (Ticker ignored = IndexingTimers.DOC_CREATION_CHANGEHISTORY.start(new String[0]);){
            if (changeHistoryGroup == null) {
                Optional<Document> optional = Optional.empty();
                return optional;
            }
            log.debug("Indexing changeHistoryGroup: issueId={}, changeHistoryGroupId={}, version={}", new Object[]{changeHistoryGroup.getIssueId(), changeHistoryGroup.getId(), changeHistoryGroupWithVersion.getVersion()});
            String changeItemUser = changeHistoryGroup.getUserKey();
            Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(changeHistoryGroupWithVersion).addSearchableField("projid", String.valueOf(changeHistoryGroup.getProjectId()), Field.Store.NO)).addSearchableField("issue_id", String.valueOf(changeHistoryGroup.getIssueId()), Field.Store.YES)).addSortableField("issue_id", String.valueOf(changeHistoryGroup.getIssueId()))).addSearchableField("key", String.valueOf(changeHistoryGroup.getIssueKey()), Field.Store.YES)).addSearchableField("ch_who", DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(changeItemUser), Field.Store.NO)).addSearchableField("ch_date", changeHistoryGroup.getCreated(), Field.Store.YES);
            for (ChangeHistoryItem changeItem : changeHistoryGroup.getChangeItems()) {
                String changedField = changeItem.getField();
                if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(changedField)) continue;
                builder.addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(ChangeHistoryGroup.class));
                ((Builder)builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_duration"), String.valueOf(changeItem.getDuration()), Field.Store.NO)).addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_nextchangedate"), changeItem.getNextChangeCreated(), Field.Store.NO);
                for (String from : changeItem.getFroms().values()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_from"), DefaultChangeHistoryDocumentFactory.encodeProtocol(from), Field.Store.NO);
                }
                for (String to : changeItem.getTos().values()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_to"), DefaultChangeHistoryDocumentFactory.encodeProtocol(to), Field.Store.NO);
                }
                for (String fromValue : changeItem.getFroms().keySet()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_oldvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(fromValue), Field.Store.YES);
                }
                for (String toValue : changeItem.getTos().keySet()) {
                    builder.addSearchableField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_newvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(toValue), Field.Store.YES);
                }
            }
            Optional<Document> optional = builder.build();
            return optional;
        }
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<ChangeHistoryGroup, Builder> {
        private Builder(EntityWithVersion<ChangeHistoryGroup> entity) {
            super(entity, "changes");
        }

        @Override
        protected String getDocumentType() {
            return "changehistory";
        }

        @Override
        protected IndexDirectoryFactory.Name getIndexName() {
            return IndexDirectoryFactory.Name.CHANGE_HISTORY;
        }
    }
}

