/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexedChangeHistoryField;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.index.IndexingLimitsStats;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DefaultChangeHistoryRetriever
implements DefaultIssueIndexer.ChangeHistoryRetriever {
    private final JiraProperties jiraProperties;
    private final ChangeHistoryManager changeManager;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final IndexingLimitsStats indexingLimitsStats;

    public DefaultChangeHistoryRetriever(@Nonnull JiraProperties jiraProperties, @Nonnull ChangeHistoryManager changeManager, @Nonnull IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, @Nonnull JqlChangeItemMapping jqlChangeItemMapping, @Nonnull IndexingLimitsStats indexingLimitsStats) {
        this.jiraProperties = jiraProperties;
        this.changeManager = (ChangeHistoryManager)Assertions.notNull((String)"changeManager", (Object)changeManager);
        this.indexedChangeHistoryFieldManager = (IndexedChangeHistoryFieldManager)Assertions.notNull((String)"indexedChangeHistoryFieldManager", (Object)indexedChangeHistoryFieldManager);
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.indexingLimitsStats = indexingLimitsStats;
        this.indexingLimitsStats.settingsChangeHistory(this.getChangelogsIndexingLimit(), this.shouldFilterOutUnsupportedFields());
    }

    @Override
    public List<EntityWithVersion<ChangeHistoryGroup>> retrieve(EntityWithVersion<Issue> issueWithVersion) {
        List changeHistoryItems = this.changeManager.getAllChangeItems(issueWithVersion.getEntity());
        int limit = this.getChangelogsIndexingLimit();
        this.indexingLimitsStats.settingsChangeHistory(limit, this.shouldFilterOutUnsupportedFields());
        List<ChangeHistoryGroup> groups = this.createChangeGroupsFromChangeItems(changeHistoryItems, issueWithVersion);
        this.indexingLimitsStats.changeHistory(groups.size(), limit >= 0 && groups.size() > limit, issueWithVersion.getEntity().getKey());
        Stream<Object> changeHistoryGroupsToIndex = limit < 0 ? groups.stream() : groups.stream().sorted().skip(Math.max(groups.size() - limit, 0));
        return this.addVersion(issueWithVersion.getVersion(), changeHistoryGroupsToIndex).collect(Collectors.toList());
    }

    private Stream<EntityWithVersion<ChangeHistoryGroup>> addVersion(long issueVersion, Stream<ChangeHistoryGroup> groupsToCreateDocumentsFrom) {
        return groupsToCreateDocumentsFrom.map(c -> new EntityWithVersion<ChangeHistoryGroup>((ChangeHistoryGroup)c, issueVersion));
    }

    private List<ChangeHistoryGroup> createChangeGroupsFromChangeItems(List<ChangeHistoryItem> changeHistoryItems, EntityWithVersion<Issue> issue) {
        List<Object> changeItemsToCreateDocumentsFrom;
        Collection indexedChangeHistoryFields = this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFields();
        Collection indexedFieldNames = this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames();
        Stream<ChangeHistoryItem> changeItemsForSupportedFields = this.processChangeItemsWithSupportedFields(changeHistoryItems, issue.getEntity(), indexedChangeHistoryFields);
        if (this.shouldFilterOutUnsupportedFields()) {
            changeItemsToCreateDocumentsFrom = changeItemsForSupportedFields.collect(Collectors.toList());
        } else {
            Stream<ChangeHistoryItem> changeItemsForUnindexedFields = changeHistoryItems.stream().filter(ci -> !indexedFieldNames.contains(this.jqlChangeItemMapping.mapJqlClauseToFieldName(ci.getField())));
            changeItemsToCreateDocumentsFrom = Stream.concat(changeItemsForUnindexedFields, changeItemsForSupportedFields).collect(Collectors.toList());
        }
        this.storeFilteringStats(changeHistoryItems, changeItemsToCreateDocumentsFrom);
        return this.groupByChangeGroup(changeItemsToCreateDocumentsFrom);
    }

    private void storeFilteringStats(List<ChangeHistoryItem> changeHistoryItemsBeforeFiltering, List<ChangeHistoryItem> changeHistoryItemsAfterFiltering) {
        long changeHistoryGroupsBeforeFilteringCount = changeHistoryItemsBeforeFiltering.stream().map(ChangeHistoryItem::getChangeGroupId).distinct().count() + 1L;
        int itemsBeforeFiltering = changeHistoryItemsBeforeFiltering.size() + this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFields().size();
        this.indexingLimitsStats.changeHistoryFiltering(itemsBeforeFiltering, changeHistoryItemsAfterFiltering.size(), changeHistoryGroupsBeforeFilteringCount);
    }

    private Stream<ChangeHistoryItem> processChangeItemsWithSupportedFields(List<ChangeHistoryItem> changeHistoryItems, Issue issue, Collection<IndexedChangeHistoryField> indexedChangeHistoryFields) {
        return indexedChangeHistoryFields.stream().map(field -> {
            List indexedChangeItems = changeHistoryItems.stream().filter(changeHistoryItem -> field.getFieldName().equals(this.jqlChangeItemMapping.mapJqlClauseToFieldName(changeHistoryItem.getField()))).collect(Collectors.toList());
            return field.getDateRangeBuilder().buildDateRanges(issue, indexedChangeItems);
        }).flatMap(Collection::stream);
    }

    private List<ChangeHistoryGroup> groupByChangeGroup(List<ChangeHistoryItem> changeItemsToCreateDocumentsFrom) {
        return changeItemsToCreateDocumentsFrom.stream().sorted().collect(Collectors.groupingBy(ChangeHistoryItem::getChangeGroupId)).values().stream().map(listOfItems -> {
            ChangeHistoryGroup.Builder builder = new ChangeHistoryGroup.Builder();
            listOfItems.forEach(arg_0 -> ((ChangeHistoryGroup.Builder)builder).addChangeItem(arg_0));
            return builder.build();
        }).collect(Collectors.toList());
    }

    private Integer getChangelogsIndexingLimit() {
        return this.jiraProperties.getInteger("jira.safeguards.indexing.issue.changelogs", Integer.valueOf(100));
    }

    private boolean shouldFilterOutUnsupportedFields() {
        return this.jiraProperties.getBoolean("jira.safeguards.indexing.issue.changelogs.do.not.filter.out.unsupported.fields") == false;
    }
}

