/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.util.profiling.Ticker;
import java.util.Date;
import java.util.Optional;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommentDocumentFactory
implements CommentDocumentFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommentDocumentFactory.class);
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultCommentDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = searchExtractorManager;
    }

    @Override
    public Optional<Document> createDocument(EntityWithVersion<Comment> commentWithVersion) {
        Comment comment = commentWithVersion.getEntity();
        try (Ticker ignored = IndexingTimers.DOC_CREATION_COMMENT.start(new String[0]);){
            Date updated;
            ApplicationUser updateAuthor;
            Issue issue = comment.getIssue();
            String body = comment.getBody();
            if (body == null) {
                Optional<Document> optional = Optional.empty();
                return optional;
            }
            log.debug("Indexing comment: issueId={}, commentId={}, version={}", new Object[]{issue.getId(), comment.getId(), commentWithVersion.getVersion()});
            Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(commentWithVersion).addSearchableField("projid", String.valueOf(issue.getProjectId()), Field.Store.YES)).addSearchableField("issue_id", String.valueOf(issue.getId()), Field.Store.YES)).addSortableField("issue_id", String.valueOf(issue.getId()))).addSearchableField("id", String.valueOf(comment.getId()), Field.Store.YES)).addTokenizedField("body", body, Field.Store.YES)).addTokenizedField(PhraseQuerySupportField.forIndexField((String)"body"), body, Field.Store.YES)).addSearchableField("comment_created", comment.getCreated(), Field.Store.YES)).addKeywordWithDefault("level", comment.getGroupLevel(), "-1")).addKeywordWithDefault("role_level", comment.getRoleLevel() != null ? comment.getRoleLevel().getId() : null, "-1")).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Comment.class));
            ApplicationUser author = comment.getAuthorApplicationUser();
            if (author != null) {
                builder.addSearchableField("comment_author", author.getKey(), Field.Store.YES);
            }
            if ((updateAuthor = comment.getUpdateAuthorApplicationUser()) != null) {
                builder.addSearchableField("comment_update_author", updateAuthor.getKey(), Field.Store.YES);
            }
            if ((updated = comment.getUpdated()) != null) {
                builder.addSearchableField("comment_updated", updated, Field.Store.YES);
                builder.addSortableField("sort_comment_updated", updated);
            }
            Optional<Document> optional = builder.build();
            return optional;
        }
    }

    @Override
    public Term getIdentifyingTerm(Comment comment) {
        return new Term(IndexDirectoryFactory.Name.COMMENT.getEntityIdFieldName(), comment.getId().toString());
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Comment, Builder> {
        private Builder(EntityWithVersion<Comment> entity) {
            super(entity, "comments");
        }

        @Override
        protected String getDocumentType() {
            return "comment";
        }

        @Override
        protected IndexDirectoryFactory.Name getIndexName() {
            return IndexDirectoryFactory.Name.COMMENT;
        }
    }
}

