/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexingLimitsStats;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.versioning.EntityVersioningManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DefaultCommentRetriever
implements DefaultIssueIndexer.CommentRetriever {
    private final JiraProperties jiraProperties;
    private final CommentManager commentManager;
    private final EntityVersioningManager entityVersioningManager;
    private final IndexingLimitsStats indexingLimitsStats;

    public DefaultCommentRetriever(@Nonnull JiraProperties jiraProperties, @Nonnull CommentManager commentManager, @Nonnull EntityVersioningManager entityVersioningManager, @Nonnull IndexingLimitsStats indexingLimitsStats) {
        this.jiraProperties = jiraProperties;
        this.commentManager = (CommentManager)Assertions.notNull((String)"commentManager", (Object)commentManager);
        this.entityVersioningManager = entityVersioningManager;
        this.indexingLimitsStats = indexingLimitsStats;
        this.indexingLimitsStats.settingMaxCommentsIndexed(this.getCommentsIndexingLimit());
    }

    @Override
    public List<EntityWithVersion<Comment>> retrieve(EntityWithVersion<Issue> issueWithVersion) {
        Map<Long, Long> commentIdToCommentVersion = this.entityVersioningManager.getRelatedCommentVersions(issueWithVersion.getEntity().getId());
        List comments = this.commentManager.getComments(issueWithVersion.getEntity());
        int limit = this.getCommentsIndexingLimit();
        this.indexingLimitsStats.settingMaxCommentsIndexed(limit);
        this.indexingLimitsStats.comments(comments.size(), limit >= 0 && comments.size() > limit, issueWithVersion.getEntity().getKey());
        Stream<EntityWithVersion> sortedComments = comments.stream().map(c -> new EntityWithVersion<Comment>((Comment)c, commentIdToCommentVersion.getOrDefault(c.getId(), EntityDocumentFactory.ENTITY_VERSION_ZERO))).sorted(new EntityWithCommentComparator().reversed());
        if (limit < 0) {
            return sortedComments.collect(Collectors.toList());
        }
        return sortedComments.limit(limit).collect(Collectors.toList());
    }

    @Override
    public Optional<Comment> retrieveById(Long commentId) {
        return Optional.ofNullable(this.commentManager.getCommentById(commentId));
    }

    private Integer getCommentsIndexingLimit() {
        return this.jiraProperties.getInteger("jira.safeguards.indexing.issue.comments", Integer.valueOf(500));
    }

    static class EntityWithCommentComparator
    implements Comparator<EntityWithVersion<Comment>> {
        EntityWithCommentComparator() {
        }

        @Override
        public int compare(EntityWithVersion<Comment> o1, EntityWithVersion<Comment> o2) {
            int dateCompareResult = o1.getEntity().getUpdated().compareTo(o2.getEntity().getUpdated());
            return dateCompareResult != 0 ? dateCompareResult : o1.getEntity().getId().compareTo(o2.getEntity().getId());
        }
    }
}

