/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexConsistencyUtils {
    private static final Logger log = LoggerFactory.getLogger(IndexConsistencyUtils.class);
    @VisibleForTesting
    static final String INDEX_CONSISTENCY_TOLERANCE_PERCENTAGE_SYSTEM_PROPERTY = "com.atlassian.jira.index.consistency.tolerance.percentage";
    private static final int INDEX_CONSISTENCY_TOLERANCE_PERCENTAGE_DEFAULT_VALUE = 10;
    private static final int MINIMUM_ABSOLUTE_TOLERANCE = 10;

    private IndexConsistencyUtils() {
    }

    public static boolean isIndexConsistent(String name, int expectedCount, IndexSearcher searcher) throws IOException {
        int tolerance;
        int delta;
        int actualCount = searcher.getIndexReader().numDocs();
        int tolerancePercentage = IndexConsistencyUtils.getIndexConsistencyTolerancePercentage();
        log.debug("isIndexConsistent: '{}': expectedCount={}; actualCount={}; tolerancePercentage={}", new Object[]{name, expectedCount, actualCount, tolerancePercentage});
        if (expectedCount >= 0 && (delta = Math.abs(expectedCount - actualCount)) > (tolerance = Math.max(10, expectedCount * tolerancePercentage / 100))) {
            log.warn("Index consistency check failed for index '{}': expectedCount={}; actualCount={}; tolerancePercentage={}, tolerance={}", new Object[]{name, expectedCount, actualCount, tolerancePercentage, tolerance});
            return false;
        }
        return true;
    }

    public static int getIndexConsistencyTolerancePercentage() {
        int tolerancePercentage = JiraSystemProperties.getInstance().getInteger(INDEX_CONSISTENCY_TOLERANCE_PERCENTAGE_SYSTEM_PROPERTY, Integer.valueOf(10));
        if (tolerancePercentage < 0) {
            log.warn("Property {} must be set to a value between 0 and 100, but was {}. Capping to 0.", (Object)INDEX_CONSISTENCY_TOLERANCE_PERCENTAGE_SYSTEM_PROPERTY, (Object)tolerancePercentage);
            return 0;
        }
        if (tolerancePercentage > 100) {
            log.warn("Property {} must be set to a value between 0 and 100, but was {}. Capping to 100.", (Object)INDEX_CONSISTENCY_TOLERANCE_PERCENTAGE_SYSTEM_PROPERTY, (Object)tolerancePercentage);
            return 100;
        }
        return tolerancePercentage;
    }
}

