/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.index.IndexingFeatures;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseDetails;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public class IndexingFeaturesImpl
implements IndexingFeatures,
InitializingComponent {
    private final JiraProperties jiraProperties;
    private final EventPublisher eventPublisher;
    private final JiraLicenseManager jiraLicenseManager;
    private final ResettableLazyReference<Boolean> isDcLicensed = Lazy.resettable((Supplier)new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return this.hasDcLicense() || JiraSystemProperties.getInstance().isDevMode();
        }

        private boolean hasDcLicense() {
            return StreamSupport.stream(IndexingFeaturesImpl.this.jiraLicenseManager.getLicenses().spliterator(), false).allMatch(LicenseDetails::isDataCenter);
        }
    });
    private static final String CF_VALUE_DRIVEN_INDEXING_DISABLED = "jira.cfv.driven.indexing.disabled";
    private static final String LOCAL_CONTEXT_INDEXING_DISABLED = "jira.local.context.indexing.disabled";
    private static final String SKIP_INDEXING_NULL_DISABLED = "jira.skip.indexing.null.disabled";
    private static final String CUSTOM_FIELD_INDEXING_BATCH_SIZE = "jira.custom.field.indexing.batch.size";
    private static final int CUSTOM_FIELD_INDEXING_DEFAULT_BATCH_SIZE = 50;

    public IndexingFeaturesImpl(JiraProperties jiraProperties, JiraLicenseManager jiraLicenseManager, EventPublisher eventPublisher) {
        this.jiraProperties = jiraProperties;
        this.jiraLicenseManager = jiraLicenseManager;
        this.eventPublisher = eventPublisher;
    }

    public boolean isCFValueDrivenIndexingEnabled() {
        return (Boolean)this.isDcLicensed.get() != false && this.jiraProperties.getBoolean(CF_VALUE_DRIVEN_INDEXING_DISABLED) == false;
    }

    public boolean isLocalContextIndexingEnabled() {
        return (Boolean)this.isDcLicensed.get() != false && this.jiraProperties.getBoolean(LOCAL_CONTEXT_INDEXING_DISABLED) == false;
    }

    public boolean isSkipIndexingNullEnabled() {
        return (Boolean)this.isDcLicensed.get() != false && this.jiraProperties.getBoolean(SKIP_INDEXING_NULL_DISABLED) == false;
    }

    public int getCustomFieldIndexingBatchSize() {
        Integer customValue = this.jiraProperties.getInteger(CUSTOM_FIELD_INDEXING_BATCH_SIZE);
        if (customValue != null && customValue > 0) {
            return customValue;
        }
        return 50;
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.isDcLicensed.reset();
    }
}

