/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.context.IssueContext;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;

@Internal
public final class SharedCustomFieldsVisibilityCache {
    private static final ThreadLocal<ConcurrentHashMap<IssueContext, Set<String>>> fieldVisibilityCacheThreadLocal = new ThreadLocal();

    private SharedCustomFieldsVisibilityCache() {
    }

    public static void setThreadLocal(ConcurrentHashMap<IssueContext, Set<String>> customFieldsVisibilityCache) {
        fieldVisibilityCacheThreadLocal.set(customFieldsVisibilityCache);
    }

    public static void clearThreadLocal() {
        fieldVisibilityCacheThreadLocal.remove();
    }

    @Nonnull
    public static Set<String> computeIfAbsent(IssueContext issueContext, Function<IssueContext, Set<String>> getVisibleCustomFieldsUncached) {
        ConcurrentHashMap<IssueContext, Set<String>> fieldVisibilityCache = fieldVisibilityCacheThreadLocal.get();
        if (fieldVisibilityCache == null) {
            return getVisibleCustomFieldsUncached.apply(issueContext);
        }
        return fieldVisibilityCache.computeIfAbsent(issueContext, getVisibleCustomFieldsUncached);
    }
}

