/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.ElisionFilter;

public class ItalianAnalyzer
extends TextAnalyzer {
    private final Function<TokenStream, TokenStream> stemmingFilter;
    private final Function<TokenStream, TokenStream> stopWordFilter;
    private static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList("c", "l", "all", "dall", "dell", "nell", "sull", "coll", "pell", "gl", "agl", "dagl", "degl", "negl", "sugl", "un", "m", "t", "s", "v", "d"), true));

    public ItalianAnalyzer(boolean indexing, Function<TokenStream, TokenStream> stemmingFilter, Function<TokenStream, TokenStream> stopWordFilter) {
        super(indexing);
        this.stemmingFilter = stemmingFilter;
        this.stopWordFilter = stopWordFilter;
    }

    @Override
    public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
        ClassicTokenizer tokenizer;
        ClassicTokenizer result = tokenizer = new ClassicTokenizer();
        result = new StandardFilter((TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new ElisionFilter((TokenStream)result, DEFAULT_ARTICLES);
        result = new LowerCaseFilter((TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingFilter.apply((Object)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

