/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class LabelsIndexer
extends BaseFieldIndexer {
    public static final String NO_VALUE_INDEX_VALUE = "<EMPTY>";

    public LabelsIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forLabels().getFieldId();
    }

    public String getDocumentFieldId() {
        return "labels_folded";
    }

    public void addIndex(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Set labels = issue.getLabels();
        boolean searchable = this.isFieldVisibleAndInScope(issue);
        if (labels == null || labels.isEmpty()) {
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), NO_VALUE_INDEX_VALUE, Field.Store.NO));
                doc.add((IndexableField)new SortedSetDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)NO_VALUE_INDEX_VALUE)));
            }
        } else {
            for (Label label : labels) {
                String theLabel = label.getLabel();
                if (!StringUtils.isNotBlank((CharSequence)theLabel)) continue;
                if (searchable) {
                    doc.add((IndexableField)new StringField("labels", theLabel, Field.Store.YES));
                    doc.add((IndexableField)new StringField(this.getDocumentFieldId(), theLabel.toLowerCase(), Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField("labels", new BytesRef((CharSequence)theLabel)));
                    continue;
                }
                doc.add((IndexableField)new StoredField("labels", theLabel));
            }
        }
    }
}

