/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class PriorityIndexer
extends BaseFieldIndexer {
    public PriorityIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forPriority().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forPriority().getIndexField();
    }

    public void addIndex(Document doc, Issue issue) {
        if (issue.getPriorityObject() != null) {
            this.indexKeyword(doc, this.getDocumentFieldId(), issue.getPriorityObject().getId(), issue);
        } else {
            this.indexKeyword(doc, this.getDocumentFieldId(), "-1", issue);
        }
    }
}

