/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class VotesIndexer
extends BaseFieldIndexer {
    private final VoteManager voteManager;

    public VotesIndexer(FieldVisibilityManager fieldVisibilityManager, VoteManager voteManager) {
        super(fieldVisibilityManager);
        this.voteManager = voteManager;
    }

    public String getId() {
        return SystemSearchConstants.forVotes().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forVotes().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.voteManager.isVotingEnabled();
    }

    public void addIndex(Document doc, Issue issue) {
        this.indexLongAsPaddedKeywordWithDefault(doc, this.getDocumentFieldId(), issue.getVotes(), 0L, issue);
    }
}

