/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.worklog.WorkRatio;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.ofbiz.core.entity.GenericValue;

public class WorkRatioIndexer
extends BaseFieldIndexer {
    private final ApplicationProperties applicationProperties;

    public WorkRatioIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        super(fieldVisibilityManager);
        this.applicationProperties = applicationProperties;
    }

    public String getId() {
        return SystemSearchConstants.forWorkRatio().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forWorkRatio().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    public void addIndex(Document doc, Issue issue) {
        if (issue.getOriginalEstimate() != null) {
            doc.add((IndexableField)new StringField(this.getDocumentFieldId(), WorkRatio.getPaddedWorkRatio((GenericValue)issue.getGenericValue()), Field.Store.YES));
            doc.add((IndexableField)new NumericDocValuesField(this.getDocumentFieldId(), WorkRatio.getWorkRatio((Issue)issue)));
        }
    }
}

