/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.managers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.cache.ZduCacheMigrationHelper;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexerWithStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStatsCollector;
import com.atlassian.jira.issue.index.indexers.FieldIndexerWithStats;
import com.atlassian.jira.issue.index.indexers.impl.AffectedVersionsIndexer;
import com.atlassian.jira.issue.index.indexers.impl.AssigneeIndexer;
import com.atlassian.jira.issue.index.indexers.impl.AttachmentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ComponentsIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CreatedDateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CreatorIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CurrentEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.DescriptionIndexer;
import com.atlassian.jira.issue.index.indexers.impl.DueDateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.EnvironmentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FixForVersionsIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueIdIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueKeyIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueLinkIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueTypeIndexer;
import com.atlassian.jira.issue.index.indexers.impl.LabelsIndexer;
import com.atlassian.jira.issue.index.indexers.impl.OriginalEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ParentIssueIndexer;
import com.atlassian.jira.issue.index.indexers.impl.PriorityIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ProgressIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ProjectIdIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ReporterIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ResolutionIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SecurityIndexer;
import com.atlassian.jira.issue.index.indexers.impl.StatusIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SubTaskIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SummaryIndexer;
import com.atlassian.jira.issue.index.indexers.impl.TimeSpentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.UpdatedDateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VoterIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VotesIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WatcherIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WatchesIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WorkRatioIndexer;
import com.atlassian.jira.issue.index.managers.FieldIndexerLoader;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Suppliers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;

public class FieldIndexerManagerImpl
implements FieldIndexerManager {
    private static final String SYSTEM_FIELD_INDEXERS_CACHE_NAME = FieldIndexerManagerImpl.class.getName() + ".systemFieldIndexers";
    private static final String CUSTOM_FIELD_INDEXERS_CACHE_NAME = FieldIndexerManagerImpl.class.getName() + ".customFieldIndexers";
    private static final Collection<Class<? extends FieldIndexer>> KNOWN_INDEXER_TYPES = Arrays.asList(AffectedVersionsIndexer.class, AssigneeIndexer.class, ComponentsIndexer.class, CreatedDateIndexer.class, CurrentEstimateIndexer.class, DescriptionIndexer.class, DueDateIndexer.class, EnvironmentIndexer.class, FixForVersionsIndexer.class, IssueIdIndexer.class, IssueKeyIndexer.class, IssueTypeIndexer.class, OriginalEstimateIndexer.class, ParentIssueIndexer.class, PriorityIndexer.class, ProjectIdIndexer.class, ReporterIndexer.class, ResolutionIndexer.class, SecurityIndexer.class, StatusIndexer.class, SubTaskIndexer.class, SummaryIndexer.class, TimeSpentIndexer.class, UpdatedDateIndexer.class, VotesIndexer.class, VoterIndexer.class, WatchesIndexer.class, WatcherIndexer.class, WorkRatioIndexer.class, ProgressIndexer.class, LabelsIndexer.class, IssueLinkIndexer.class, AttachmentIndexer.class, CreatorIndexer.class);
    private final CachedReference<Set<FieldIndexerWithStats>> systemFieldIndexersCache;
    private final CachedReference<Set<CustomFieldIndexerWithStats>> customFieldIndexersCache;

    private static Set<FieldIndexerWithStats> lookupKnownIndexers() {
        return (Set)KNOWN_INDEXER_TYPES.stream().map(componentClass -> (FieldIndexer)ComponentManager.getInstance().loadComponent(componentClass, (Collection<Object>)Collections.emptyList())).map(FieldIndexerWithStats::createKnown).collect(ImmutableSet.toImmutableSet());
    }

    public FieldIndexerManagerImpl(IssueSearcherManager searcherManager, CacheManager cacheManager) {
        this(cacheManager, Suppliers.memoize(() -> FieldIndexerManagerImpl.lookupKnownIndexers()), new FieldIndexerLoader(searcherManager)::loadSystemFieldIndexers, new FieldIndexerLoader(searcherManager)::loadCustomFieldIndexers);
    }

    @VisibleForTesting
    FieldIndexerManagerImpl(CacheManager cacheManager, Supplier<Set<FieldIndexerWithStats>> knownIndexers, Supplier<Set<FieldIndexerWithStats>> systemFieldIndexerLoader, Supplier<Set<CustomFieldIndexerWithStats>> customFieldIndexerLoader) {
        this.systemFieldIndexersCache = cacheManager.getCachedReference(SYSTEM_FIELD_INDEXERS_CACHE_NAME, () -> Sets.union((Set)((Set)knownIndexers.get()), (Set)((Set)systemFieldIndexerLoader.get())));
        this.customFieldIndexersCache = ZduCacheMigrationHelper.migrate((CacheFactory)cacheManager, "com.atlassian.jira.issue.index.managers.FieldIndexerManagerImpl.allIssueIndexers", ZduCacheMigrationHelper.JiraVersion.JIRA_8_9, cacheManager.getCachedReference(CUSTOM_FIELD_INDEXERS_CACHE_NAME, customFieldIndexerLoader::get));
    }

    @Override
    public Collection<FieldIndexer> getAllIssueIndexers() {
        return Sets.union((Set)((Set)this.systemFieldIndexersCache.get()), (Set)((Set)this.customFieldIndexersCache.get()));
    }

    @Override
    public Collection<FieldIndexer> getSystemFieldIndexers() {
        return Collections.unmodifiableSet((Set)this.systemFieldIndexersCache.get());
    }

    @Override
    public Collection<CustomFieldIndexer> getCustomFieldIndexers() {
        return Collections.unmodifiableSet((Set)this.customFieldIndexersCache.get());
    }

    @Override
    public Collection<FieldIndexerStatsCollector> getIssueIndexerStatsCollectors() {
        return Collections.unmodifiableSet(Sets.union((Set)((Set)this.customFieldIndexersCache.get()), (Set)((Set)this.systemFieldIndexersCache.get())));
    }

    @Override
    public void refresh() {
        this.customFieldIndexersCache.reset();
    }
}

