/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.label.AlphabeticalLabelGroupingService;
import com.atlassian.jira.issue.label.AlphabeticalLabelGroupingSupport;
import com.atlassian.jira.issue.label.AlphabeticalLabelRenderer;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;

public class DefaultAlphabeticalLabelRenderer
implements AlphabeticalLabelRenderer {
    private AlphabeticalLabelGroupingService alphabeticalLabelGroupingService;
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final LabelUtil labelUtil;
    private final I18nHelper.BeanFactory beanFactory;

    public DefaultAlphabeticalLabelRenderer(AlphabeticalLabelGroupingService alphabeticalLabelGroupingService, VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ProjectManager projectManager, LabelUtil labelUtil, I18nHelper.BeanFactory beanFactory) {
        this.alphabeticalLabelGroupingService = alphabeticalLabelGroupingService;
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.labelUtil = labelUtil;
        this.beanFactory = beanFactory;
    }

    @Override
    public String getHtml(ApplicationUser remoteUser, Long projectId, String fieldId, boolean isOtherFieldsExist) {
        try {
            AlphabeticalLabelGroupingSupport alphabeticallyGroupedLabels = this.alphabeticalLabelGroupingService.getAlphabeticallyGroupedLabels(remoteUser, projectId, fieldId);
            Map<String, Object> startingParams = this.getDefaultVelocityParams();
            startingParams.put("field", this.fieldManager.getField(fieldId));
            startingParams.put("project", this.projectManager.getProjectObj(projectId));
            startingParams.put("labelUtils", this.labelUtil);
            startingParams.put("labelCount", alphabeticallyGroupedLabels.getUniqueLabelsCount());
            startingParams.put("alphaSupport", alphabeticallyGroupedLabels);
            startingParams.put("isCustomField", fieldId.startsWith("customfield_"));
            startingParams.put("remoteUser", remoteUser);
            startingParams.put("i18n", this.beanFactory.getInstance(remoteUser));
            startingParams.put("isOtherFieldsExist", isOtherFieldsExist);
            return this.templatingEngine.render(TemplateSources.file((String)"templates/plugins/jira/projectpanels/labels-alphabetical.vm")).applying(startingParams).asHtml();
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Map<String, Object> getDefaultVelocityParams() {
        return JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
    }
}

