/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkDeletedEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkCreator;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.link.LinkCollectionImpl;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.model.querydsl.QIssueLink;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueLinkManager
implements IssueLinkManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueLinkManager.class);
    private static final int BATCH_SIZE = 1000;
    private final OfBizDelegator delegator;
    private final QueryDslAccessor queryDslAccessor;
    private final IssueLinkCreator issueLinkCreator;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueUpdater issueUpdater;
    private final IssueIndexingService issueIndexingService;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private static final String OUTWARD_LINKS_CACHE_KEY = DefaultIssueLinkManager.class.getName() + ".outwardLinks";
    private static final String INWARD_LINKS_CACHE_KEY = DefaultIssueLinkManager.class.getName() + ".inwardLinks";
    private final RequestCache<Long, List<IssueLink>> outwardLinksCache;
    private final RequestCache<Long, List<IssueLink>> inwardLinksCache;

    public DefaultIssueLinkManager(OfBizDelegator genericDelegator, QueryDslAccessor queryDslAccessor, IssueLinkCreator issueLinkCreator, IssueLinkTypeManager issueLinkTypeManager, IssueUpdater issueUpdater, IssueIndexingService issueIndexingService, ApplicationProperties applicationProperties, RequestCacheFactory requestCacheFactory, EventPublisher eventPublisher) {
        this.delegator = genericDelegator;
        this.queryDslAccessor = queryDslAccessor;
        this.issueLinkCreator = issueLinkCreator;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueUpdater = issueUpdater;
        this.issueIndexingService = issueIndexingService;
        this.applicationProperties = applicationProperties;
        this.outwardLinksCache = requestCacheFactory.createRequestCache(OUTWARD_LINKS_CACHE_KEY, issueId -> ImmutableList.copyOf(this.getLinks("source", (Long)issueId)));
        this.inwardLinksCache = requestCacheFactory.createRequestCache(INWARD_LINKS_CACHE_KEY, issueId -> ImmutableList.copyOf(this.getLinks("destination", (Long)issueId)));
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence, ApplicationUser remoteUser) throws CreateException {
        if (this.getIssueLink(sourceId, destinationId, issueLinkTypeId) != null) {
            return;
        }
        if (!this.validateIssueLinkType(issueLinkTypeId)) {
            String msg = String.format("There is no IssueLinkType with id: %s", issueLinkTypeId);
            log.error(msg);
            throw new CreateException(msg);
        }
        IssueLink issueLink = null;
        try {
            issueLink = this.storeIssueLink(sourceId, destinationId, issueLinkTypeId, sequence);
            IssueLinkType issueLinkType = issueLink.getIssueLinkType();
            if (!issueLinkType.isSystemLinkType()) {
                this.createCreateIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            if (issueLink != null) {
                this.invalidateRequestCache(issueLink);
                this.reindexLinkedIssues(issueLink);
            }
        }
        this.eventPublisher.publish((Object)new IssueLinkCreatedEvent(issueLink, Instant.now()));
    }

    protected void reindexLinkedIssues(IssueLink issueLink) {
        try {
            this.issueIndexingService.reIndex(issueLink.getSourceObject(), IssueIndexingParams.INDEX_ISSUE_WITH_HISTORY);
            this.issueIndexingService.reIndex(issueLink.getDestinationObject(), IssueIndexingParams.INDEX_ISSUE_WITH_HISTORY);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    private List<IssueLink> getIssueLinks(Map<String, ?> key) {
        List<GenericValue> result = this.delegator.findByAnd("IssueLink", key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return this.buildIssueLinks(result);
    }

    private void createCreateIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, ApplicationUser remoteUser) {
        Issue source = issueLink.getSourceObject();
        Issue destination = issueLink.getDestinationObject();
        ChangeItemBean cib = new ChangeItemBean("jira", "Link", null, null, destination.getKey(), "This issue " + issueLinkType.getOutward() + ' ' + destination.getKey());
        this.createChangeItem(source, cib, remoteUser);
        cib = new ChangeItemBean("jira", "Link", null, null, source.getKey(), "This issue " + issueLinkType.getInward() + ' ' + source.getKey());
        this.createChangeItem(destination, cib, remoteUser);
    }

    private void createChangeItem(Issue issue, ChangeItemBean changeItemBean, ApplicationUser remoteUser) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue, issue, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems((Collection)ImmutableList.of((Object)changeItemBean));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    public void removeIssueLink(IssueLink issueLink, ApplicationUser remoteUser) {
        this.removeIssueLinkInternal(issueLink, remoteUser, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIssueLinkInternal(IssueLink issueLink, ApplicationUser remoteUser, boolean createChangeItem) {
        if (issueLink == null) {
            throw new IllegalArgumentException("Link cannot be null");
        }
        try {
            IssueLinkType issueLinkType;
            this.delegator.removeByAnd("IssueLink", (Map)FieldMap.build((String)"id", (Object)issueLink.getId()));
            if (log.isDebugEnabled()) {
                log.debug("Deleted link with id '" + issueLink.getId() + "'.");
            }
            if (createChangeItem && !(issueLinkType = issueLink.getIssueLinkType()).isSystemLinkType()) {
                this.createRemoveIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            this.invalidateRequestCache(issueLink);
            this.reindexLinkedIssues(issueLink);
        }
        this.eventPublisher.publish((Object)new IssueLinkDeletedEvent(issueLink, Instant.now()));
    }

    private void createRemoveIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, ApplicationUser remoteUser) {
        Issue source = issueLink.getSourceObject();
        Issue destination = issueLink.getDestinationObject();
        ChangeItemBean cib = new ChangeItemBean("jira", "Link", destination.getKey(), "This issue " + issueLinkType.getOutward() + ' ' + destination.getKey(), null, null);
        this.createChangeItem(source, cib, remoteUser);
        cib = new ChangeItemBean("jira", "Link", source.getKey(), "This issue " + issueLinkType.getInward() + ' ' + source.getKey(), null, null);
        this.createChangeItem(destination, cib, remoteUser);
    }

    public int removeIssueLinks(Issue issue, ApplicationUser remoteUser) {
        return this.removeIssueLinksInternal(issue, remoteUser, true);
    }

    public int removeIssueLinks(GenericValue issue, ApplicationUser remoteUser) {
        if (issue == null) {
            return 0;
        }
        return this.removeIssueLinksInternal((Issue)ComponentAccessor.getIssueFactory().getIssue(issue), remoteUser, true);
    }

    public int removeIssueLinksNoChangeItems(Issue issue) {
        return this.removeIssueLinksInternal(issue, null, false);
    }

    private int removeIssueLinksInternal(Issue issue, ApplicationUser remoteUser, boolean createChangeItem) {
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getId());
        this.deleteIssueLinksFromIssue(outwardLinks, remoteUser, createChangeItem);
        int totalLinksDeleted = outwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug("Deleted " + outwardLinks.size() + " outward links from issue " + issue.getKey());
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getId());
        this.deleteIssueLinksFromIssue(inwardLinks, remoteUser, createChangeItem);
        totalLinksDeleted += inwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug("Deleted " + inwardLinks.size() + " inward links from issue " + issue.getKey());
        }
        return totalLinksDeleted;
    }

    private void deleteIssueLinksFromIssue(List<IssueLink> issueLinks, ApplicationUser remoteUser, boolean createChangeItem) {
        if (issueLinks != null) {
            for (IssueLink issueLink : issueLinks) {
                this.removeIssueLinkInternal(issueLink, remoteUser, createChangeItem);
            }
        }
    }

    public LinkCollection getLinkCollection(GenericValue issue, ApplicationUser remoteUser) {
        return this._getLinkCollection((Issue)ComponentAccessor.getIssueFactory().getIssue(issue), remoteUser, false, true);
    }

    public LinkCollection getLinkCollection(Issue issue, ApplicationUser remoteUser) {
        return this._getLinkCollection(issue, remoteUser, false, true);
    }

    public LinkCollection getLinkCollection(Issue issue, ApplicationUser remoteUser, boolean excludeSystemLinks) {
        return this._getLinkCollection(issue, remoteUser, false, excludeSystemLinks);
    }

    public LinkCollection getLinkCollectionOverrideSecurity(Issue issue) {
        return this._getLinkCollection(issue, null, true, true);
    }

    private LinkCollection _getLinkCollection(Issue issue, ApplicationUser remoteUser, boolean overrideSecurity, boolean excludeSystemLinks) {
        TreeSet<IssueLinkType> linkTypes = new TreeSet<IssueLinkType>();
        HashMap<String, List<Issue>> outwardLinkMap = new HashMap<String, List<Issue>>();
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getId());
        if (outwardLinks != null) {
            for (IssueLink issueLink : outwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getDestinationObject();
                if (issueLinkType.isSubTaskLinkType() && linkedIssue instanceof MutableIssue) {
                    ((MutableIssue)linkedIssue).setParentObject(issue);
                }
                this.storeInLinkMap(outwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getId());
        HashMap<String, List<Issue>> inwardLinkMap = new HashMap<String, List<Issue>>();
        if (inwardLinks != null) {
            for (IssueLink issueLink : inwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getSourceObject();
                this.storeInLinkMap(inwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        return new LinkCollectionImpl(issue.getId(), linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, overrideSecurity, this.applicationProperties);
    }

    public List<IssueLink> getOutwardLinks(Long sourceId) {
        return Optional.ofNullable(sourceId).map(arg_0 -> this.outwardLinksCache.get(arg_0)).orElse((List)ImmutableList.of());
    }

    public List<IssueLink> getInwardLinks(Long destinationId) {
        return Optional.ofNullable(destinationId).map(arg_0 -> this.inwardLinksCache.get(arg_0)).orElse((List)ImmutableList.of());
    }

    public Map<Long, List<IssueLink>> getInwardLinksInBatch(List<Long> destinationIssueIds) {
        if (destinationIssueIds == null) {
            return Collections.emptyMap();
        }
        List batches = Lists.partition(destinationIssueIds, (int)1000);
        HashMap<Long, List<IssueLink>> linkMap = new HashMap<Long, List<IssueLink>>();
        for (List batch : batches) {
            List links = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QIssueLink.ISSUE_LINK).from((Expression)QIssueLink.ISSUE_LINK)).where((Predicate)QIssueLink.ISSUE_LINK.destination.in((Collection)batch))).fetch());
            linkMap.putAll(links.stream().map(linkDTO -> this.issueLinkCreator.createIssueLink(linkDTO.toGenericValue(this.delegator))).collect(Collectors.groupingBy(IssueLink::getDestinationId, Collectors.toList())));
        }
        return linkMap;
    }

    public Map<Long, List<IssueLink>> getOutwardLinksInBatch(List<Long> sourceIssueIds) {
        if (sourceIssueIds == null) {
            return Collections.emptyMap();
        }
        List batches = Lists.partition(sourceIssueIds, (int)1000);
        HashMap<Long, List<IssueLink>> linkMap = new HashMap<Long, List<IssueLink>>();
        for (List batch : batches) {
            List links = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QIssueLink.ISSUE_LINK).from((Expression)QIssueLink.ISSUE_LINK)).where((Predicate)QIssueLink.ISSUE_LINK.source.in((Collection)batch))).fetch());
            linkMap.putAll(links.stream().map(linkDTO -> this.issueLinkCreator.createIssueLink(linkDTO.toGenericValue(this.delegator))).collect(Collectors.groupingBy(IssueLink::getSourceId, Collectors.toList())));
        }
        return linkMap;
    }

    public Map<Long, List<IssueLink>> getInwardLinksInBatch(List<Long> destinationIssueIds, IssueLinkType issueLinkType) {
        if (destinationIssueIds == null || issueLinkType == null) {
            return null;
        }
        List linkIDs = this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QIssueLink.ISSUE_LINK.id).from((Expression)QIssueLink.ISSUE_LINK)).where((Predicate)QIssueLink.ISSUE_LINK.destination.in((Collection)destinationIssueIds).and((Predicate)QIssueLink.ISSUE_LINK.linktype.eq((Object)issueLinkType.getId())))).fetch());
        return linkIDs.stream().map(this::getIssueLink).collect(Collectors.groupingBy(IssueLink::getDestinationId, Collectors.toList()));
    }

    private List<IssueLink> getLinks(String fieldId, Long issueId) {
        return Select.from(Entity.ISSUE_LINK).whereEqual(fieldId, issueId).runWith(this.delegator).asList();
    }

    public void moveIssueLink(List<IssueLink> issueLinks, Long currentSequence, Long sequence) {
        if (currentSequence == null) {
            throw new IllegalArgumentException("Current sequence cannot be null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null.");
        }
        int currentIndex = currentSequence.intValue();
        int index = sequence.intValue();
        CollectionReorderer.moveToPosition(issueLinks, currentIndex, index);
        this.resetSequences(issueLinks);
    }

    public void resetSequences(List<IssueLink> issueLinks) {
        this.queryDslAccessor.execute(dbConnection -> {
            long i = 0L;
            for (IssueLink issueLink : issueLinks) {
                dbConnection.update((RelationalPath<?>)QIssueLink.ISSUE_LINK).set(QIssueLink.ISSUE_LINK.sequence, (Object)i).where((Predicate)QIssueLink.ISSUE_LINK.id.eq((Object)issueLink.getId())).execute();
                ++i;
            }
        });
        this.invalidateRequestCache();
    }

    public IssueLink getIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId) {
        List<IssueLink> links = this.getIssueLinks((Map<String, ?>)FieldMap.build((String)"source", (Object)sourceId));
        for (IssueLink link : links) {
            if (!link.getDestinationId().equals(destinationId) || !link.getLinkTypeId().equals(issueLinkTypeId)) continue;
            return link;
        }
        return null;
    }

    public Collection<IssueLink> getIssueLinks(Long issueLinkTypeId) {
        return this.getIssueLinks((Map<String, ?>)FieldMap.build((String)"linktype", (Object)issueLinkTypeId));
    }

    public IssueLink getIssueLink(Long issueLinkId) {
        Assertions.notNull((String)"issueLinkId", (Object)issueLinkId);
        GenericValue issueLinkGV = this.delegator.findByPrimaryKey("IssueLink", issueLinkId);
        if (issueLinkGV == null) {
            return null;
        }
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIssueLinkType(IssueLink issueLink, IssueLinkType swapLinkType, ApplicationUser remoteUser) {
        IssueLinkType oldIssueLinkType = issueLink.getIssueLinkType();
        if (!oldIssueLinkType.isSystemLinkType() && swapLinkType.isSystemLinkType()) {
            log.warn("Changing non-system link type to a system link type.");
        } else if (oldIssueLinkType.isSystemLinkType() && !swapLinkType.isSystemLinkType()) {
            log.warn("Changing system link type to a non-system link type.");
        }
        try {
            this.updateIssueLinkType(issueLink, swapLinkType);
        }
        finally {
            this.invalidateRequestCache(issueLink);
        }
        if (!oldIssueLinkType.isSystemLinkType()) {
            this.createRemoveIssueLinkChangeItems(issueLink, oldIssueLinkType, remoteUser);
            this.createCreateIssueLinkChangeItems(issueLink, swapLinkType, remoteUser);
        }
    }

    private void updateIssueLinkType(IssueLink issueLink, IssueLinkType issueLinkType) {
        this.queryDslAccessor.execute(dbConnection -> dbConnection.update((RelationalPath<?>)QIssueLink.ISSUE_LINK).set(QIssueLink.ISSUE_LINK.linktype, (Object)issueLinkType.getId()).where((Predicate)QIssueLink.ISSUE_LINK.id.eq((Object)issueLink.getId())).execute());
    }

    public boolean isLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    private IssueLink storeIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence) {
        FieldMap fields = FieldMap.build((String)"source", (Object)sourceId, (String)"destination", (Object)destinationId, (String)"linktype", (Object)issueLinkTypeId, (String)"sequence", (Object)sequence);
        return this.buildIssueLink(this.delegator.createValue("IssueLink", (Map)fields));
    }

    private List<IssueLink> buildIssueLinks(Collection<GenericValue> issueLinkGVs) {
        ArrayList<IssueLink> issueLinks = new ArrayList<IssueLink>(issueLinkGVs.size());
        for (GenericValue issueLinkGV : issueLinkGVs) {
            issueLinks.add(this.buildIssueLink(issueLinkGV));
        }
        return issueLinks;
    }

    private IssueLink buildIssueLink(GenericValue issueLinkGV) {
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    private void storeInLinkMap(Map<String, List<Issue>> linkMap, String linkTypeName, Issue linkedIssue) {
        List<Issue> matchingLinks = linkMap.get(linkTypeName);
        if (matchingLinks == null) {
            matchingLinks = new ArrayList<Issue>();
            linkMap.put(linkTypeName, matchingLinks);
        }
        matchingLinks.add(linkedIssue);
    }

    private void invalidateRequestCache() {
        this.inwardLinksCache.removeAll();
        this.outwardLinksCache.removeAll();
    }

    private void invalidateRequestCache(IssueLink issueLink) {
        this.outwardLinksCache.remove((Object)issueLink.getSourceId());
        this.inwardLinksCache.remove((Object)issueLink.getDestinationId());
    }

    private boolean validateIssueLinkType(long linkTypeId) {
        return this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(linkTypeId), false) != null;
    }
}

