/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkCreateEvent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkDecoratedEvent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkDeleteEvent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkUpdateEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.GetException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.link.RemoteIssue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLinkStore;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultRemoteIssueLinkManager
implements RemoteIssueLinkManager {
    public static final int MAX_LONG_VARCHAR_LENGTH = 255;
    public static final int MAX_GLOBAL_ID_LIST_SIZE_FOR_FIND = 100;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRemoteIssueLinkManager.class);
    private final RemoteIssueLinkStore remoteIssueLinkStore;
    private final IssueManager issueManager;
    private final IssueUpdater issueUpdater;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final EventPublisher eventPublisher;
    private final IssueIndexingService issueIndexingService;
    private static final Result TRUE = new Result(true, null);

    public DefaultRemoteIssueLinkManager(RemoteIssueLinkStore remoteIssueLinkStore, IssueManager issueManager, IssueUpdater issueUpdater, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher, IssueIndexingService issueIndexingService) {
        this.remoteIssueLinkStore = remoteIssueLinkStore;
        this.issueManager = issueManager;
        this.issueUpdater = issueUpdater;
        this.i18nBeanFactory = i18nBeanFactory;
        this.eventPublisher = eventPublisher;
        this.issueIndexingService = issueIndexingService;
    }

    public RemoteIssueLink getRemoteIssueLink(Long remoteIssueLinkId) {
        return this.remoteIssueLinkStore.getRemoteIssueLink(remoteIssueLinkId);
    }

    public List<RemoteIssueLink> getRemoteIssueLinksForIssue(Issue issue) {
        return this.remoteIssueLinkStore.getRemoteIssueLinksForIssue(issue);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public RemoteIssueLink getRemoteIssueLinkByGlobalId(Issue issue, String globalId) {
        return (RemoteIssueLink)Iterables.get(this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, globalId), (int)0, null);
    }

    public List<RemoteIssueLink> findRemoteIssueLinksByGlobalIds(Collection<String> globalIds) throws GetException {
        this.validateGlobalIdsForGet(globalIds);
        return this.remoteIssueLinkStore.findRemoteIssueLinksByGlobalIds(globalIds);
    }

    public RemoteIssueLink createRemoteIssueLink(RemoteIssueLink remoteIssueLink, ApplicationUser user) throws CreateException {
        this.validateMandatoryFieldsForCreate(remoteIssueLink);
        this.validateFieldLengthsForCreate(remoteIssueLink);
        this.validateUrlsForCreate(remoteIssueLink);
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        if (issue == null) {
            throw new CreateException("Issue with id '" + remoteIssueLink.getIssueId() + "' does not exist.");
        }
        this.validateGlobalIdForCreate((Issue)issue, remoteIssueLink.getGlobalId());
        RemoteIssueLink created = this.remoteIssueLinkStore.createRemoteIssueLink(remoteIssueLink);
        if (this.hasDuplicateGlobalId((Issue)issue, created)) {
            this.remoteIssueLinkStore.removeRemoteIssueLink(created.getId());
            throw new CreateException("A remote issue link already exists on this issue with the globalId '" + created.getGlobalId() + "'");
        }
        this.createChangeItemForCreate(created, (Issue)issue, user);
        this.reindexIssue((Issue)issue);
        this.eventPublisher.publish((Object)new RemoteIssueLinkCreateEvent(remoteIssueLink));
        return created;
    }

    public List<RemoteIssue> createRemoteIssuesFromRemoteIssueLinks(List<RemoteIssueLink> remoteIssueLinks) {
        return remoteIssueLinks.stream().map(remoteIssueLink -> new RemoteIssue(remoteIssueLink.getTitle(), Boolean.TRUE.equals(remoteIssueLink.isResolved()), remoteIssueLink.getUrl(), remoteIssueLink.getSummary())).collect(Collectors.toList());
    }

    public void updateRemoteIssueLink(RemoteIssueLink remoteIssueLink, ApplicationUser user) throws UpdateException {
        this.validateMandatoryFieldsForUpdate(remoteIssueLink);
        this.validateFieldLengthsForUpdate(remoteIssueLink);
        this.validateUrlsForUpdate(remoteIssueLink);
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        if (issue == null) {
            throw new UpdateException("Issue with id '" + remoteIssueLink.getIssueId() + "' does not exist.");
        }
        RemoteIssueLink found = this.getRemoteIssueLink(remoteIssueLink.getId());
        if (found == null) {
            throw new UpdateException("Remote link with id '" + remoteIssueLink.getId() + "' does not exist.");
        }
        this.validateGlobalIdForUpdate((Issue)issue, found.getGlobalId(), remoteIssueLink.getGlobalId());
        this.remoteIssueLinkStore.updateRemoteIssueLink(remoteIssueLink);
        if (found.getGlobalId() != null && !found.getGlobalId().equals(remoteIssueLink.getGlobalId()) && this.hasDuplicateGlobalId((Issue)issue, remoteIssueLink)) {
            this.remoteIssueLinkStore.updateRemoteIssueLink(found);
            throw new UpdateException("A remote issue link already exists on this issue with the globalId '" + remoteIssueLink.getGlobalId() + "'");
        }
        this.createChangeItemForUpdate(found, remoteIssueLink, (Issue)issue, user);
        this.reindexIssue((Issue)issue);
        this.eventPublisher.publish((Object)new RemoteIssueLinkUpdateEvent(remoteIssueLink));
    }

    public void removeRemoteIssueLink(Long remoteIssueLinkId, ApplicationUser user) {
        RemoteIssueLink remoteIssueLink = this.getRemoteIssueLink(remoteIssueLinkId);
        if (remoteIssueLink == null) {
            return;
        }
        this.removeRemoteIssueLink(remoteIssueLink, user);
    }

    public void removeRemoteIssueLinkByGlobalId(Issue issue, String globalId, ApplicationUser user) {
        List<RemoteIssueLink> remoteIssueLinks = this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, globalId);
        if (remoteIssueLinks.isEmpty()) {
            return;
        }
        for (RemoteIssueLink remoteIssueLink : Lists.reverse(remoteIssueLinks)) {
            this.removeRemoteIssueLink(remoteIssueLink, user);
        }
    }

    public long getTotalRemoteIssueLinkCountByGlobalId(String globalId) {
        return this.remoteIssueLinkStore.getTotalRemoteIssueLinkCountByGlobalId(globalId);
    }

    @EventListener
    public void onRemoteIssueLinkDecorated(RemoteIssueLinkDecoratedEvent event) {
        RemoteIssueLink remoteIssueLink = event.getRemoteIssueLink();
        if (this.shouldUpdateRemoteIssueLinkInStore(remoteIssueLink)) {
            try {
                this.updateRemoteIssueLink(remoteIssueLink, event.getUser());
            }
            catch (UpdateException e) {
                logger.warn("Failed to update remote issue link with id {}.", (Object)remoteIssueLink.getId());
            }
        }
    }

    private void removeRemoteIssueLink(RemoteIssueLink remoteIssueLink, ApplicationUser user) {
        this.remoteIssueLinkStore.removeRemoteIssueLink(remoteIssueLink.getId());
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        this.createChangeItemForRemove(remoteIssueLink, (Issue)issue, user);
        this.reindexIssue((Issue)issue);
        this.eventPublisher.publish((Object)new RemoteIssueLinkDeleteEvent(remoteIssueLink));
    }

    private void reindexIssue(Issue issue) {
        try {
            this.issueIndexingService.reIndex(issue);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateGlobalIdForCreate(Issue issue, String globalId) throws CreateException {
        Result result = this.validateGlobalId(issue, globalId);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateGlobalIdForUpdate(Issue issue, String oldGlobalId, String newGlobalId) throws UpdateException {
        Result result;
        if (!this.isEqual(oldGlobalId, newGlobalId) && !(result = this.validateGlobalId(issue, newGlobalId)).isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateGlobalId(Issue issue, String globalId) {
        if (globalId == null) {
            return TRUE;
        }
        if (this.getRemoteIssueLinkByGlobalId(issue, globalId) != null) {
            return new Result(false, "A remote issue link already exists on this issue with the globalId '" + globalId + "'");
        }
        return TRUE;
    }

    private void validateGlobalIdsForGet(Collection<String> globalIds) throws GetException {
        Result result = this.validateGlobalIds(globalIds);
        if (!result.isValid()) {
            throw new GetException(result.getMessage());
        }
    }

    private Result validateGlobalIds(Collection<String> globalIds) {
        if (globalIds != null) {
            if (globalIds.size() > 100) {
                return new Result(false, "The number of globalIds cannot exceed 100.");
            }
            for (String globalId : globalIds) {
                if (globalId == null) {
                    return new Result(false, "A globalId in the input collection is null.");
                }
                if (!this.isLongerThan(globalId, 255)) continue;
                return new Result(false, this.tooLongFieldMessage("globalId", 255));
            }
        }
        return TRUE;
    }

    private boolean hasDuplicateGlobalId(Issue issue, RemoteIssueLink link) {
        if (link.getGlobalId() == null) {
            return false;
        }
        List<RemoteIssueLink> links = this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, link.getGlobalId());
        return links.size() > 1;
    }

    private void validateMandatoryFieldsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateMandatoryFields(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateMandatoryFieldsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        if (remoteIssueLink.getId() == null) {
            throw new UpdateException(this.missingMandatoryFieldMessage("id"));
        }
        Result result = this.validateMandatoryFields(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateMandatoryFields(RemoteIssueLink remoteIssueLink) {
        if (remoteIssueLink.getIssueId() == null) {
            return new Result(false, this.missingMandatoryFieldMessage("issueId"));
        }
        if (StringUtils.isBlank((CharSequence)remoteIssueLink.getTitle())) {
            return new Result(false, this.missingMandatoryFieldMessage("title"));
        }
        if (StringUtils.isBlank((CharSequence)remoteIssueLink.getUrl())) {
            return new Result(false, this.missingMandatoryFieldMessage("url"));
        }
        return TRUE;
    }

    private void validateFieldLengthsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateFieldLengths(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateFieldLengthsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        Result result = this.validateFieldLengths(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateFieldLengths(RemoteIssueLink remoteIssueLink) {
        if (this.isLongerThan(remoteIssueLink.getGlobalId(), 255)) {
            return new Result(false, this.tooLongFieldMessage("globalId", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getTitle(), 255)) {
            return new Result(false, this.tooLongFieldMessage("title", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getRelationship(), 255)) {
            return new Result(false, this.tooLongFieldMessage("relationship", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationType(), 255)) {
            return new Result(false, this.tooLongFieldMessage("applicationType", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationName(), 255)) {
            return new Result(false, this.tooLongFieldMessage("applicationName", 255));
        }
        return TRUE;
    }

    private boolean isLongerThan(String value, int length) {
        return value != null && value.length() > length;
    }

    private void validateUrlsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateUrls(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateUrlsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        Result result = this.validateUrls(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateUrls(RemoteIssueLink remoteIssueLink) {
        if (!this.isValidUrl(remoteIssueLink.getUrl())) {
            return new Result(false, this.invalidUrlMessage("url"));
        }
        if (!this.isValidUrl(remoteIssueLink.getIconUrl())) {
            return new Result(false, this.invalidUrlMessage("iconUrl"));
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconUrl())) {
            return new Result(false, this.invalidUrlMessage("statusIconUrl"));
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconLink())) {
            return new Result(false, this.invalidUrlMessage("statusIconLink"));
        }
        return TRUE;
    }

    private boolean isValidUrl(String url) {
        if (url == null) {
            return true;
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private void createChangeItemForCreate(RemoteIssueLink remoteIssueLink, Issue issue, ApplicationUser remoteUser) {
        ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", null, null, remoteIssueLink.getId().toString(), this.getChangeItemDescription(remoteIssueLink, remoteUser));
        this.createChangeItem(changeItemBean, issue, remoteUser);
    }

    private void createChangeItemForRemove(RemoteIssueLink remoteIssueLink, Issue issue, ApplicationUser remoteUser) {
        ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", remoteIssueLink.getId().toString(), this.getChangeItemDescription(remoteIssueLink, remoteUser), null, null);
        this.createChangeItem(changeItemBean, issue, remoteUser);
    }

    private void createChangeItemForUpdate(RemoteIssueLink oldLink, RemoteIssueLink newLink, Issue issue, ApplicationUser remoteUser) {
        String oldLinkDesc = this.getChangeItemDescription(oldLink, remoteUser);
        String newLinkDesc = this.getChangeItemDescription(newLink, remoteUser);
        if (!oldLink.getId().equals(newLink.getId()) || !oldLinkDesc.equals(newLinkDesc)) {
            ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", oldLink.getId().toString(), oldLinkDesc, newLink.getId().toString(), newLinkDesc);
            this.createChangeItem(changeItemBean, issue, remoteUser);
        }
    }

    private String getChangeItemDescription(RemoteIssueLink remoteIssueLink, ApplicationUser remoteUser) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(remoteUser);
        String applicationName = (String)StringUtils.defaultIfEmpty((CharSequence)remoteIssueLink.getApplicationName(), (CharSequence)i18nHelper.getText("remotelink.manager.changeitem.applicationname.default"));
        return i18nHelper.getText("remotelink.manager.changeitem", remoteIssueLink.getTitle(), applicationName);
    }

    private void createChangeItem(ChangeItemBean changeItemBean, Issue issue, ApplicationUser remoteUser) {
        GenericValue issueGv = issue.getGenericValue();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issueGv, issueGv, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems((Collection)EasyList.build((Object)changeItemBean));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    private boolean isEqual(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    private String missingMandatoryFieldMessage(String fieldName) {
        return "Missing mandatory field: " + fieldName;
    }

    private String invalidUrlMessage(String fieldName) {
        return "Invalid " + fieldName + ", it must be a valid URI";
    }

    private String tooLongFieldMessage(String fieldName, int maxLength) {
        return "The length of the " + fieldName + " cannot exceed " + maxLength + " characters.";
    }

    private boolean shouldUpdateRemoteIssueLinkInStore(RemoteIssueLink remoteIssueLink) {
        return !remoteIssueLink.equals((Object)this.getRemoteIssueLink(remoteIssueLink.getId()));
    }

    private static class Result {
        private final boolean valid;
        private final String message;

        private Result(boolean valid, String message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

