/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.WebRequestUtils;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentIdSequencer;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.AttachmentKeys;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.ConvertTemporaryAttachmentParams;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.EitherUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Unit;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

public class DefaultAttachmentManager
implements AttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentManager.class);
    private static final int NOT_THUMBNAILABLE = 0;
    private static final int IS_THUMBNAILABLE = 1;
    private static final int NOT_ZIP = 0;
    private static final int IS_ZIP = 1;
    private static final Function<AttachmentError, String> GET_ATTACHMENT_ERROR_MESSAGE = error -> String.format("%s: %s.", error.getFilename(), error.getLogMessage());
    private static final Function<Attachment, ChangeItemBean> ATTACHMENT_TO_CHANGE_ITEM_BEAN = attachment -> new ChangeItemBean("jira", "Attachment", null, null, attachment.getId().toString(), attachment.getFilename());
    private final ApplicationProperties applicationProperties;
    private final AttachmentKeyMapper attachmentKeyMapper;
    private final AttachmentIdSequencer attachmentIdSequencer;
    private final AttachmentIndexManager attachmentIndexManager;
    private final AttachmentConfigStore attachmentConfigStore;
    private final ComponentLocator componentLocator;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final IssueManager issueManager;
    private final MimeManager mimeManager;
    private final OfBizDelegator ofBizDelegator;
    private final StreamAttachmentStore streamAttachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;
    private final UserManager userManager;

    public DefaultAttachmentManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, MimeManager mimeManager, ApplicationProperties applicationProperties, AttachmentConfigStore attachmentConfigStore, AttachmentKeyMapper attachmentKeyMapper, ComponentLocator componentLocator, I18nHelper.BeanFactory i18nBeanFactory, UserManager userManager, AttachmentIndexManager attachmentIndexManager, StreamAttachmentStore streamAttachmentStore, ThumbnailAccessor thumbnailAccessor, AttachmentIdSequencer attachmentIdSequencer) {
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
        this.mimeManager = mimeManager;
        this.applicationProperties = applicationProperties;
        this.attachmentConfigStore = attachmentConfigStore;
        this.attachmentKeyMapper = Objects.requireNonNull(attachmentKeyMapper);
        this.componentLocator = componentLocator;
        this.i18nBeanFactory = i18nBeanFactory;
        this.userManager = userManager;
        this.attachmentIndexManager = attachmentIndexManager;
        this.streamAttachmentStore = streamAttachmentStore;
        this.thumbnailAccessor = thumbnailAccessor;
        this.attachmentIdSequencer = attachmentIdSequencer;
    }

    public Attachment getAttachment(Long id) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", id);
        }
        catch (DataAccessException e) {
            DefaultAttachmentManager.logInvalidAttachmentIdError(id);
            throw e;
        }
        if (attachmentGV == null) {
            throw new AttachmentNotFoundException((Object)id);
        }
        return new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV));
    }

    private static void logInvalidAttachmentIdError(Object attachmentId) {
        log.error("Unable to find a file attachment with id: {}", attachmentId);
    }

    public List<Attachment> getAttachments(Issue issue) {
        return this.getStoredAttachments(issue);
    }

    public List<Attachment> getStoredAttachments(Issue issue) {
        try {
            GenericValue issueGV = issue.getGenericValue();
            List attachmentGvs = issueGV.getRelatedOrderBy("ChildFileAttachment", (List)ImmutableList.of((Object)"filename ASC", (Object)"created DESC"));
            return attachmentGvs.stream().map(attachmentGV -> new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV))).collect(Collectors.toList());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<Attachment> getStoredAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        List<Attachment> attachments = this.getStoredAttachments(issue);
        attachments.sort(comparator);
        return attachments;
    }

    public List<Attachment> getAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        return this.getStoredAttachments(issue, comparator);
    }

    public Attachment createAttachmentCopySourceFile(File file, String filename, String contentType, String attachmentAuthor, Issue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return DefaultAttachmentManager.raiseExceptionOnError(this.createAttachmentImpl(new CreateAttachmentParamsBean.Builder(file, filename, contentType, this.userManager.getUserByName(attachmentAuthor), issue).attachmentProperties(attachmentProperties).createdTime(createdTime).copySourceFile(Boolean.valueOf(true)).build()));
    }

    public Attachment createAttachment(GenericValue issue, @Nullable ApplicationUser author, String mimetype, String filename, Long filesize, Map<String, Object> attachmentProperties, Date createdTime) {
        Long attachmentId = this.attachmentIdSequencer.getNextId();
        return this.insertAttachment(issue.getLong("id"), ApplicationUsers.getKeyFor(author), mimetype, filename, filesize, null, null, attachmentProperties, createdTime, attachmentId);
    }

    private Attachment insertAttachment(Long issueId, @Nullable String authorKey, String mimetype, String filename, Long filesize, @Nullable Boolean zip, @Nullable Boolean thumbnailable, @Nullable Map<String, Object> attachmentProperties, Date createdTime, Long attachmentId) {
        String sanitisedMimeType = this.mimeManager.getSanitisedMimeType(mimetype, filename);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issueId);
        fields.put("author", authorKey);
        fields.put("mimetype", sanitisedMimeType);
        fields.put("filename", filename);
        fields.put("filesize", filesize);
        fields.put("id", attachmentId);
        if (zip != null) {
            fields.put("zip", zip != false ? 1 : 0);
        }
        if (thumbnailable != null) {
            fields.put("thumbnailable", thumbnailable != false ? 1 : 0);
        }
        Timestamp createdTimeAsTimestamp = createdTime != null ? new Timestamp(createdTime.getTime()) : null;
        fields.put("created", createdTimeAsTimestamp);
        GenericValue attachmentGV = this.ofBizDelegator.createValue("FileAttachment", fields);
        if (attachmentProperties != null) {
            PropertySet propSet = this.createAttachmentPropertySet(attachmentGV, attachmentProperties);
            return new Attachment(this.issueManager, attachmentGV, propSet);
        }
        return new Attachment(this.issueManager, attachmentGV);
    }

    public void deleteAttachment(Attachment attachment) throws RemoveException {
        Issue issue = attachment.getIssue();
        try {
            this.streamAttachmentStore.deleteAttachment(this.attachmentKeyMapper.fromAttachment(attachment)).claim();
            this.deleteThumbnailForAttachment(null, attachment);
            this.ofBizDelegator.removeAll(Collections.singletonList(attachment.getGenericValue()));
            this.attachmentIndexManager.removeAttachmentIndex(attachment, issue);
        }
        catch (AttachmentCleanupException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public void deleteAttachmentDirectory(Issue issue) throws RemoveException {
        if (issue != null && this.attachmentsEnabled()) {
            File[] attachmentDirFiles;
            Optional<FileStore.Path> attachmentPath = this.streamAttachmentStore.getAttachmentPathForIssue(issue);
            File attachmentDir = attachmentPath.filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).orElseThrow(() -> new RemoveException("Attachment path '" + attachmentPath + "' is not a filesystem path."));
            if (!attachmentDir.isDirectory()) {
                throw new RemoveException("Attachment path '" + attachmentDir + "' is not a directory");
            }
            if (!attachmentDir.canWrite()) {
                throw new RemoveException("Can't write to attachment directory '" + attachmentDir + "'");
            }
            File thumbnailDirectory = new File(attachmentDir, "thumbs");
            if (thumbnailDirectory.exists()) {
                File[] thumbnails = thumbnailDirectory.listFiles();
                if (thumbnails == null) {
                    log.error("Unable to delete the issue attachment thumbnail directory '{}' due to error while getting files list.", (Object)thumbnailDirectory);
                } else if (thumbnails.length == 0) {
                    boolean deleted = thumbnailDirectory.delete();
                    if (!deleted) {
                        log.error("Unable to delete the issue attachment thumbnail directory '{}'.", (Object)thumbnailDirectory);
                    }
                } else {
                    log.error("Unable to delete the issue attachment thumbnail directory '{}' because it is not empty.", (Object)thumbnailDirectory);
                }
            }
            if ((attachmentDirFiles = attachmentDir.listFiles()) == null) {
                log.error("Unable to delete the issue attachment directory '{}' due to error while getting files list.", (Object)attachmentDir);
            } else if (attachmentDirFiles.length == 0) {
                if (!attachmentDir.delete()) {
                    log.error("Unable to delete the issue attachment directory '{}'.", (Object)attachmentDir);
                }
            } else {
                log.error("Unable to delete the issue attachment directory '{}' because it is not empty.", (Object)attachmentDir);
            }
        }
    }

    private IssueFactory getIssueFactory() {
        return (IssueFactory)this.componentLocator.getComponent(IssueFactory.class);
    }

    public boolean attachmentsEnabled() {
        return this.attachmentConfigStore.getConfig().isAttachmentsEnabled();
    }

    public boolean isScreenshotAppletEnabled() {
        return this.applicationProperties.getOption("jira.screenshotapplet.enabled");
    }

    protected boolean isScreenshotAppletEnabledForLinux() {
        return this.applicationProperties.getOption("jira.screenshotapplet.linux.enabled");
    }

    public boolean isScreenshotAppletSupportedByOS() {
        if (this.isScreenshotAppletEnabledForLinux()) {
            return true;
        }
        int browserOS = this.getUsersOS();
        return browserOS == 10 || browserOS == 20;
    }

    public AttachmentsBulkOperationResult<ChangeItemBean> tryConvertTemporaryAttachments(@Nullable ApplicationUser user, Issue issue, List<Long> selectedAttachments, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"selectedAttachments", selectedAttachments);
        Assertions.notNull((String)"temporaryAttachmentsMonitor", (Object)temporaryAttachmentsMonitor);
        return new AttachmentsBulkOperationResult(EitherUtils.splitEithers(ImmutableList.copyOf((Iterable)Iterables.transform(selectedAttachments, selectedAttachment -> this.transformTemporaryAttachment((Long)selectedAttachment, temporaryAttachmentsMonitor, user, issue)))));
    }

    private Either<AttachmentError, ChangeItemBean> transformTemporaryAttachment(Long selectedAttachment, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor, @Nullable ApplicationUser user, Issue issue) {
        TemporaryAttachment tempAttachment = temporaryAttachmentsMonitor.getById(selectedAttachment);
        if (tempAttachment == null) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.temp.file.not.exists");
            return this.attachmentError("Temporary attachment missing: " + selectedAttachment, errorMessage, "#" + selectedAttachment, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(tempAttachment.getFile(), tempAttachment.getFilename(), tempAttachment.getContentType(), user, issue).build());
    }

    @VisibleForTesting
    int getUsersOS() {
        HttpServletRequest servletRequest = ExecutingHttpRequest.get();
        if (servletRequest == null) {
            servletRequest = ServletActionContext.getRequest();
        }
        return WebRequestUtils.getBrowserOperationSystem(servletRequest);
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return DefaultAttachmentManager.raiseExceptionOnError(this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(file, filename, contentType, remoteUser, issue).attachmentProperties(attachmentProperties).createdTime(createdTime).build()));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return DefaultAttachmentManager.raiseExceptionOnError(this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(file, filename, contentType, remoteUser, issue).zip(zip).thumbnailable(thumbnailable).attachmentProperties(attachmentProperties).createdTime(createdTime).build()));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser author, GenericValue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, author, issue, null, null, attachmentProperties, createdTime);
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser author, GenericValue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, author, (Issue)this.getIssueFactory().getIssue(issue), zip, thumbnailable, attachmentProperties, createdTime);
    }

    private static <T> T raiseExceptionOnError(Either<AttachmentError, T> result) throws AttachmentException {
        return (T)Eithers.getOrThrow((Either)result.left().map(attachmentError -> new AttachmentException(String.format("Got error while saving attachment %s: %s", attachmentError.getFilename(), attachmentError.getLogMessage()), (Throwable)attachmentError.getException().getOrNull())));
    }

    private Either<AttachmentError, Attachment> createAttachmentImpl(CreateAttachmentParamsBean params) {
        return this.createAttachmentFromFile(params.getFile(), params.getFilename(), params.getContentType(), params.getAuthor(), params.getIssue(), params.getZip(), params.getThumbnailable(), params.getAttachmentProperties(), params.getCreatedTime(), params.getCopySourceFile());
    }

    private boolean validateOldCreateAttachmentArguments(File file, String filename) {
        if (file == null) {
            log.warn("Cannot create attachment without a file (filename={}).", (Object)filename);
            return false;
        }
        if (filename == null) {
            log.warn("Cannot create attachment without a filename - inline content? See https://jira.atlassian.com/browse/JRA-10825 (file={}}).", (Object)file.getName());
            return false;
        }
        return true;
    }

    private Either<AttachmentError, Attachment> createAttachmentFromFile(File file, String filename, String contentType, @Nullable ApplicationUser author, Issue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime, Boolean copySourceFile) {
        AttachmentKey attachmentKey = this.createAttachmentKey(filename, issue);
        long fileSize = file.length();
        Either<AttachmentError, StoreAttachmentResult> putResult = this.safelyPutAttachmentFileToAttachmentStore(attachmentKey, file, !Boolean.TRUE.equals(copySourceFile), author);
        return putResult.right().map(ignore -> this.insertAttachment(issue.getId(), ApplicationUsers.getKeyFor(author), contentType, filename, fileSize, zip, thumbnailable, attachmentProperties, createdTime, attachmentKey.getAttachmentId()));
    }

    private AttachmentKey createAttachmentKey(String filename, Issue issue) {
        Long attachmentId = this.attachmentIdSequencer.getNextId();
        return AttachmentKey.builder().withAttachmentFilename(filename).withIssueKey(issue.getKey()).withAttachmentId(attachmentId).withProjectKey(issue.getProjectObject().getOriginalKey()).build();
    }

    private I18nHelper getI18n(@Nullable ApplicationUser user) {
        return this.i18nBeanFactory.getInstance(user);
    }

    private <T> Either<AttachmentError, T> attachmentError(String logMessage, String localizedMessage, String filename, ErrorCollection.Reason reason) {
        log.warn(logMessage);
        return Either.left((Object)new AttachmentError(logMessage, localizedMessage, filename, Option.none(), reason));
    }

    private <T> Either<AttachmentError, T> attachmentError(String logMessage, String localizedMessage, String filename, Throwable throwable, ErrorCollection.Reason reason) {
        String messageWithException = ExceptionUtil.logExceptionWithWarn(log, logMessage, throwable);
        Option ex = throwable instanceof Exception ? Option.some((Object)((Exception)throwable)) : Option.none();
        return Either.left((Object)new AttachmentError(messageWithException, localizedMessage, filename, ex, reason));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, GenericValue issueGV) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, remoteUser, issueGV, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, remoteUser, issue, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
    }

    public ChangeItemBean createAttachment(CreateAttachmentParamsBean bean) throws AttachmentException {
        return DefaultAttachmentManager.raiseExceptionOnError(this.tryCreateAttachment(bean));
    }

    public Either<AttachmentError, ChangeItemBean> tryCreateAttachment(CreateAttachmentParamsBean params) {
        return this.createAttachmentImpl(params).right().map(ATTACHMENT_TO_CHANGE_ITEM_BEAN);
    }

    public List<ChangeItemBean> convertTemporaryAttachments(@Nullable ApplicationUser user, Issue issue, List<Long> selectedAttachments, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor) throws AttachmentException {
        AttachmentsBulkOperationResult<ChangeItemBean> convertResult = this.tryConvertTemporaryAttachments(user, issue, selectedAttachments, temporaryAttachmentsMonitor);
        if (!convertResult.getErrors().isEmpty()) {
            String errors = Joiner.on((String)" ").join(Iterables.transform((Iterable)convertResult.getErrors(), GET_ATTACHMENT_ERROR_MESSAGE));
            throw new AttachmentException("Got errors when attaching files. " + errors);
        }
        return convertResult.getResults();
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    StoreAttachmentResult putAttachmentFileToAttachmentStore(AttachmentKey attachmentKey, File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Either<AttachmentError, StoreAttachmentResult> safelyPutAttachmentFileToAttachmentStore(AttachmentKey attachmentKey, File file, boolean deleteSourceFile, @Nullable ApplicationUser user) {
        try {
            Either either = Either.right((Object)this.putAttachmentFileToAttachmentStore(attachmentKey, file));
            return either;
        }
        catch (Exception e) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.save.to.store", (Object)e);
            Either either = this.attachmentError("Got exception while saving attachment in attachment store.", errorMessage, attachmentKey.getAttachmentFilename(), e, ErrorCollection.Reason.SERVER_ERROR);
            return either;
        }
        finally {
            if (deleteSourceFile && !file.delete()) {
                log.warn("Cannot remove source attachment file {}", (Object)file);
            }
        }
    }

    private Either<AttachmentError, Unit> safelyMoveTemporaryToAttachment(AttachmentKey attachmentKey, TemporaryAttachmentId temporaryAttachmentId, @Nullable ApplicationUser user) {
        try {
            return Either.right((Object)this.streamAttachmentStore.moveTemporaryToAttachment(temporaryAttachmentId, attachmentKey).claim());
        }
        catch (Exception e) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.save.to.store", e.getMessage());
            return this.attachmentError("Got exception while saving attachment in attachment store.", errorMessage, attachmentKey.getAttachmentFilename(), e, ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    @VisibleForTesting
    PropertySet createAttachmentPropertySet(GenericValue attachment, Map<String, Object> attachmentProperties) {
        PropertySet propSet = OFBizPropertyUtils.getPropertySet(attachment);
        for (Map.Entry<String, Object> entry : attachmentProperties.entrySet()) {
            propSet.setAsActualType(entry.getKey(), entry.getValue());
        }
        return propSet;
    }

    public Attachment setThumbnailable(Attachment attachment, boolean thumbnailable) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", attachment.getId());
            attachmentGV.put("thumbnailable", (Object)(thumbnailable ? 1 : 0));
            attachmentGV.store();
        }
        catch (DataAccessException e) {
            DefaultAttachmentManager.logInvalidAttachmentIdError(attachment.getId());
            throw e;
        }
        catch (GenericEntityException e) {
            DefaultAttachmentManager.logInvalidAttachmentIdError(attachment.getId());
            throw new DataAccessException((Throwable)e);
        }
        return new Attachment(this.issueManager, attachmentGV, attachment.getProperties());
    }

    public Attachment setZip(Attachment attachment, boolean zip) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", attachment.getId());
            attachmentGV.put("zip", (Object)(zip ? 1 : 0));
            attachmentGV.store();
        }
        catch (DataAccessException e) {
            DefaultAttachmentManager.logInvalidAttachmentIdError(attachment.getId());
            throw e;
        }
        catch (GenericEntityException e) {
            DefaultAttachmentManager.logInvalidAttachmentIdError(attachment.getId());
            throw new DataAccessException((Throwable)e);
        }
        return new Attachment(this.issueManager, attachmentGV, attachment.getProperties());
    }

    public <T> T streamAttachmentContent(@Nonnull Attachment attachment, InputStreamConsumer<T> consumer) throws AttachmentReadException, NoAttachmentDataException {
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        return (T)this.streamAttachmentStore.getAttachment(attachmentKey, input -> {
            try {
                return consumer.withInputStream(input);
            }
            catch (IOException e) {
                throw new DataAccessException((Throwable)e);
            }
        }).claim();
    }

    public void moveAttachments(Issue oldIssue, String newIssueKey) {
        List<Attachment> attachments = this.getAttachments(oldIssue);
        Function<Attachment, Promise> move = attachment -> {
            this.deleteThumbnailForAttachment(oldIssue, (Attachment)attachment);
            return this.streamAttachmentStore.move((Attachment)attachment, newIssueKey).recover(this::logMoveAttachmentError);
        };
        Promises.when((Iterable)ImmutableList.copyOf((Iterable)Iterables.transform(attachments, move))).claim();
        this.deleteThumbnailsDirectoryForIssue(oldIssue);
    }

    @VisibleForTesting
    Void logMoveAttachmentError(Throwable t) {
        log.warn(t.getMessage());
        return null;
    }

    private void deleteThumbnailsDirectoryForIssue(Issue issue) {
        this.thumbnailAccessor.deleteThumbnailDirectory(issue).fail(exception -> {
            log.info("Unable to delete thumbnail path of issue {}", (Object)issue.getKey());
            this.logMoveAttachmentError((Throwable)exception);
        });
    }

    private void deleteThumbnailForAttachment(Issue issue, Attachment attachment) {
        try {
            FileStore.Path thumbnailFile;
            FileStore.Path path = thumbnailFile = issue == null ? this.thumbnailAccessor.getThumbnailFilePath(attachment) : this.thumbnailAccessor.getThumbnailFilePath(issue, attachment);
            if (thumbnailFile.tryFileExists()) {
                thumbnailFile.deleteFile();
            }
        }
        catch (AttachmentReadException | IOException e) {
            log.warn(String.format("Unable to delete thumbnail for attachment %s", attachment.getId().toString()), e);
        }
    }

    public Either<AttachmentError, Attachment> copyAttachment(Attachment attachment, @Nullable ApplicationUser author, String newIssueKey) {
        return this.copyAttachments(Contexts.nullContext(), Collections.singletonList(attachment), author, newIssueKey).get(attachment.getId());
    }

    public Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Issue issue, @Nullable ApplicationUser author, String newIssueKey) {
        return this.copyAttachments(Contexts.nullContext(), this.getAttachments(issue), author, newIssueKey);
    }

    public Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Context context, Issue issue, @Nullable ApplicationUser author, String newIssueKey) {
        return this.copyAttachments(context, this.getAttachments(issue), author, newIssueKey);
    }

    private <A> Map<Long, A> fillMap(List<Attachment> attachments, Function<Attachment, A> f) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attachment attachment : attachments) {
            builder.put((Object)attachment.getId(), f.apply(attachment));
        }
        return builder.build();
    }

    private Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Context context, List<Attachment> attachments, @Nullable ApplicationUser author, String newIssueKey) {
        MutableIssue newIssue;
        try {
            newIssue = this.issueManager.getIssueObject(newIssueKey);
            if (newIssue == null) {
                return this.fillMap(attachments, attachment -> this.attachmentError(String.format("Unable to copy attachment because issue with key %s does not exist", newIssueKey), this.getI18n(author).getText("attachment.error.copy.issue.not.exist", newIssueKey), attachment.getFilename(), ErrorCollection.Reason.VALIDATION_FAILED));
            }
        }
        catch (DataAccessException exception) {
            return this.fillMap(attachments, attachment -> this.copyAttachmentError((Attachment)attachment, author, newIssueKey, exception));
        }
        String authorKey = ApplicationUsers.getKeyFor(author);
        Function<Attachment, Promise> copy = arg_0 -> this.lambda$copyAttachments$14(context, (Issue)newIssue, authorKey, author, newIssueKey, arg_0);
        List results = (List)Promises.when((Iterable)ImmutableList.copyOf((Iterable)Iterables.transform(attachments, copy))).claim();
        HashMap<Long, Either<AttachmentError, Attachment>> map = new HashMap<Long, Either<AttachmentError, Attachment>>(attachments.size());
        for (Pair result : results) {
            map.put((Long)result.left(), (Either<AttachmentError, Attachment>)result.right());
        }
        return map;
    }

    private Promise<Attachment> copy(Attachment originalAttachment, Attachment newAttachmentMetaData) {
        return this.streamAttachmentStore.copyAttachment(AttachmentKeys.from(originalAttachment), AttachmentKeys.from(newAttachmentMetaData)).map(unit -> newAttachmentMetaData);
    }

    public TemporaryAttachmentId createTemporaryAttachment(InputStream stream, long size) {
        return (TemporaryAttachmentId)this.streamAttachmentStore.putTemporaryAttachment(stream, size).claim();
    }

    public void deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        this.streamAttachmentStore.deleteTemporaryAttachment(temporaryAttachmentId).recover(t -> {
            log.info("Unable to delete temporary attachment with id {}", (Object)temporaryAttachmentId, t);
            return Unit.VALUE;
        }).claim();
    }

    public Either<AttachmentError, ChangeItemBean> convertTemporaryAttachment(ConvertTemporaryAttachmentParams params) {
        AttachmentKey attachmentKey = this.createAttachmentKey(params.getFilename(), params.getIssue());
        return this.safelyMoveTemporaryToAttachment(attachmentKey, params.getTemporaryAttachmentId(), params.getAuthor()).right().map(unit -> this.insertAttachment(params, attachmentKey)).right().map(ATTACHMENT_TO_CHANGE_ITEM_BEAN);
    }

    private Attachment insertAttachment(ConvertTemporaryAttachmentParams params, AttachmentKey attachmentKey) {
        Timestamp createdTime = new Timestamp(params.getCreatedTime().getMillis());
        String authorKey = ApplicationUsers.getKeyFor(params.getAuthor());
        return this.insertAttachment(params.getIssue().getId(), authorKey, params.getContentType(), params.getFilename(), params.getFileSize(), null, null, null, createdTime, attachmentKey.getAttachmentId());
    }

    private <T> Either<AttachmentError, T> copyAttachmentError(Attachment attachment, @Nullable ApplicationUser author, String newIssueKey, Throwable throwable) {
        return this.attachmentError(String.format("Unable to copy attachment to issue with key %s.", newIssueKey), this.getI18n(author).getText("attachment.error.copy.generic", newIssueKey), attachment.getFilename(), throwable, ErrorCollection.Reason.SERVER_ERROR);
    }

    public <T> T streamTemporaryAttachmentContent(@Nonnull TemporaryAttachmentId attachmentId, InputStreamConsumer<T> consumer) throws AttachmentReadException, NoAttachmentDataException {
        return (T)this.streamAttachmentStore.getTemporaryAttachment(attachmentId, input -> {
            try {
                return consumer.withInputStream(input);
            }
            catch (IOException e) {
                throw new DataAccessException((Throwable)e);
            }
        }).claim();
    }

    public void disableAttachments() {
        this.applicationProperties.setOption("jira.option.allowattachments", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Promise lambda$copyAttachments$14(Context context, Issue newIssue, String authorKey, ApplicationUser author, String newIssueKey, Attachment attachment) {
        Context.Task taskStep = context.start((Object)attachment);
        try {
            Attachment newAttachmentMetaData;
            Long attachmentId = this.attachmentIdSequencer.getNextId();
            try {
                newAttachmentMetaData = this.insertAttachment(newIssue.getId(), authorKey, attachment.getMimetype(), attachment.getFilename(), attachment.getFilesize(), attachment.isZip(), attachment.isThumbnailable(), null, UtilDateTime.nowTimestamp(), attachmentId);
            }
            catch (DataAccessException exception) {
                Promise promise = Promises.rejected((Throwable)exception);
                taskStep.complete();
                return promise;
            }
            Function<Attachment, Pair> handleResult = newAttachment -> Pair.pair((Object)attachment.getId(), (Object)Either.right((Object)newAttachment));
            Function<Throwable, Pair> rollbackAndReturnError = t -> {
                AttachmentError error = (AttachmentError)this.copyAttachmentError(attachment, author, newIssueKey, (Throwable)t).left().get();
                try {
                    this.ofBizDelegator.removeValue(newAttachmentMetaData.getGenericValue());
                }
                catch (DataAccessException exception) {
                    AttachmentError dbError = (AttachmentError)this.copyAttachmentError(attachment, author, newIssueKey, exception).left().get();
                    log.warn(dbError.getLogMessage(), (Throwable)dbError.getException().getOrNull());
                }
                return Pair.pair((Object)attachment.getId(), (Object)Either.left((Object)error));
            };
            Promise promise = this.copy(attachment, newAttachmentMetaData).map(handleResult).recover(rollbackAndReturnError);
            return promise;
        }
        finally {
            taskStep.complete();
        }
    }
}

