/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.managers.IssueAttachmentDeleteHelper;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.List;
import java.util.Objects;

public final class DefaultIssueAttachmentDeleteHelper
implements IssueAttachmentDeleteHelper {
    private final AttachmentManager attachmentManager;
    private final AttachmentConfigManager attachmentConfigManager;
    private final StreamAttachmentStore streamAttachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;

    public DefaultIssueAttachmentDeleteHelper(AttachmentManager attachmentManager, AttachmentConfigManager attachmentConfigManager, StreamAttachmentStore streamAttachmentStore, ThumbnailAccessor thumbnailAccessor) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
        this.thumbnailAccessor = Objects.requireNonNull(thumbnailAccessor);
    }

    @Override
    public Promise<Void> deleteAttachmentsForIssue(Issue issue) {
        if (this.attachmentConfigManager.isAttachmentsEnabled()) {
            return this.thumbnailAccessor.deleteThumbnailDirectory(issue).flatMap(input -> {
                List attachments = this.attachmentManager.getAttachments(issue);
                try {
                    for (Attachment a : attachments) {
                        this.attachmentManager.deleteAttachment(a);
                    }
                }
                catch (RemoveException e) {
                    return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
                }
                return this.streamAttachmentStore.deleteAttachmentContainerForIssue(issue).map(unit -> null);
            });
        }
        return Promises.promise(null);
    }
}

