/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.priority;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityIssueSearcher;
import com.atlassian.jira.project.Project;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class PrioritySchemeMigratorFinder {
    private final PrioritySchemeManager prioritySchemeManager;
    private final PriorityIssueSearcher priorityIssueSearcher;

    public PrioritySchemeMigratorFinder(PrioritySchemeManager prioritySchemeManager, PriorityIssueSearcher priorityIssueSearcher) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.priorityIssueSearcher = priorityIssueSearcher;
    }

    public Set<Priority> findUnmappedPriorities(Project project, FieldConfigScheme targetScheme) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        Preconditions.checkNotNull((Object)targetScheme.getOneAndOnlyConfig(), (Object)"targetScheme");
        Collection prioritiesInNewScheme = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(targetScheme.getOneAndOnlyConfig()));
        return this.findUnmappedPriorities(project, prioritiesInNewScheme);
    }

    public Set<Priority> findUnmappedPriorities(Project project, Collection<Priority> prioritiesInNewScheme) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        Preconditions.checkNotNull(prioritiesInNewScheme);
        Set<Priority> usedPriorities = this.priorityIssueSearcher.findUsedPriorities(project);
        return Sets.difference(usedPriorities, (Set)ImmutableSet.copyOf(prioritiesInNewScheme));
    }
}

