/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.metrics;

import com.atlassian.jira.event.MetricEvent;
import com.atlassian.jira.issue.search.metrics.LuceneQueryMetrics;
import com.atlassian.query.Query;
import java.util.Map;
import java.util.Objects;

public class LuceneQueryExecutionEvent
implements MetricEvent {
    private final Query query;
    private final Map<String, LuceneQueryMetrics.TermMetric> queryTermMetrics;
    private final long numberOfClausesInQuery;
    private final long numberOfCustomFieldsUsed;
    private final long executionTime;
    private final int numberOfResults;
    private final String collectorType;
    public static final int NUMBER_OF_RESULTS_UNKNOWN = -1;

    public LuceneQueryExecutionEvent(Query query, Map<String, LuceneQueryMetrics.TermMetric> queryTermMetrics, long executionTime, int numberOfResults, String collectorType) {
        this.query = query;
        this.queryTermMetrics = queryTermMetrics;
        this.numberOfClausesInQuery = this.sumNumberOfClauses(queryTermMetrics);
        this.numberOfCustomFieldsUsed = this.sumNumberOfCustomFields(queryTermMetrics);
        this.executionTime = executionTime;
        this.numberOfResults = numberOfResults;
        this.collectorType = collectorType;
    }

    private long sumNumberOfClauses(Map<String, LuceneQueryMetrics.TermMetric> metrics) {
        return metrics.values().stream().filter(Objects::nonNull).mapToInt(LuceneQueryMetrics.TermMetric::getCount).sum();
    }

    private long sumNumberOfCustomFields(Map<String, LuceneQueryMetrics.TermMetric> numberOfClausesPerField) {
        return numberOfClausesPerField.values().stream().filter(LuceneQueryMetrics.TermMetric::isCustomField).mapToInt(LuceneQueryMetrics.TermMetric::getCount).sum();
    }

    public Query getQuery() {
        return this.query;
    }

    public long getNumberOfClausesInQuery() {
        return this.numberOfClausesInQuery;
    }

    public long getNumberOfCustomFieldsUsed() {
        return this.numberOfCustomFieldsUsed;
    }

    public Map<String, LuceneQueryMetrics.TermMetric> getQueryTermMetrics() {
        return this.queryTermMetrics;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public String getCollectorType() {
        return this.collectorType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQueryExecutionEvent that = (LuceneQueryExecutionEvent)o;
        return this.numberOfClausesInQuery == that.numberOfClausesInQuery && this.executionTime == that.executionTime && this.numberOfResults == that.numberOfResults && Objects.equals(this.query, that.query) && Objects.equals(this.collectorType, that.collectorType);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.numberOfClausesInQuery, this.executionTime, this.numberOfResults, this.collectorType);
    }

    public String toString() {
        return "LuceneQueryExecutionEvent{query=" + this.query + ", queryTermMetrics=" + this.queryTermMetrics + ", numberOfClausesInQuery=" + this.numberOfClausesInQuery + ", executionTime=" + this.executionTime + ", numberOfResults=" + this.numberOfResults + ", collectorType='" + this.collectorType + '\'' + '}';
    }

    public String toMetrics() {
        return "LuceneQueryExecutionEvent{queryTermMetrics=" + this.queryTermMetrics + ", numberOfClausesInQuery=" + this.numberOfClausesInQuery + ", numberOfCustomFieldsUsed=" + this.numberOfCustomFieldsUsed + ", executionTime=" + this.executionTime + ", numberOfResults=" + this.numberOfResults + ", collectorType='" + this.collectorType + '\'' + '}';
    }

    public String getName() {
        return LuceneQueryExecutionEvent.class.getName();
    }
}

