/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.optimizers;

import com.atlassian.jira.jql.util.ArgumentExtractingOperandVisitor;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class DeterminedProjectsInQueryVisitor
implements ClauseVisitor<Boolean> {
    public static final String PROJECT_CLAUSE_NAME = "project";
    public static final ImmutableList<Operator> ALLOWED_OPERATORS = ImmutableList.of((Object)Operator.EQUALS, (Object)Operator.IN, (Object)Operator.IS);
    public final ImmutableSet.Builder<String> projectsSetBuilder = ImmutableSet.builder();

    public Boolean visit(AndClause andClause) {
        for (Clause clause : andClause.getClauses()) {
            if (!((Boolean)clause.accept((ClauseVisitor)this)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean visit(OrClause orClause) {
        for (Clause clause : orClause.getClauses()) {
            if (((Boolean)clause.accept((ClauseVisitor)this)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean visit(TerminalClause terminalClause) {
        if (PROJECT_CLAUSE_NAME.equalsIgnoreCase(terminalClause.getName()) && ALLOWED_OPERATORS.contains((Object)terminalClause.getOperator())) {
            List extractedProjects = (List)terminalClause.getOperand().accept((OperandVisitor)new ArgumentExtractingOperandVisitor());
            this.projectsSetBuilder.addAll((Iterable)extractedProjects);
            return !extractedProjects.isEmpty();
        }
        return false;
    }

    public Boolean visit(WasClause wasClause) {
        return false;
    }

    public Boolean visit(ChangedClause changedClause) {
        return false;
    }

    public Boolean visit(NotClause notClause) {
        return false;
    }

    public Set<String> getDeterminedProjects() {
        return this.projectsSetBuilder.build();
    }
}

