/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.providers;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Property;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PropertyTypeInfoQueryModifier {
    private final PluginIndexConfigurationManager pluginIndexConfigurationManager;

    public PropertyTypeInfoQueryModifier(PluginIndexConfigurationManager pluginIndexConfigurationManager) {
        this.pluginIndexConfigurationManager = pluginIndexConfigurationManager;
    }

    Query addPropertyTypeInfoToQuery(Query original) {
        boolean needProps;
        boolean bl = needProps = original.getOrderByClause() != null && original.getOrderByClause().getSearchSorts().stream().anyMatch(ss -> ss.getProperty().isDefined());
        if (!needProps) {
            return original;
        }
        Map<String, Map<String, IndexDocumentConfiguration.Type>> propKeyToPathToTypes = this.getPropertyKeysToPathsToTypes();
        List updatedSearchSorts = original.getOrderByClause().getSearchSorts().stream().map(origSS -> this.enrichPropertyInformation(propKeyToPathToTypes, (SearchSort)origSS)).collect(Collectors.toList());
        return new QueryImpl(original.getWhereClause(), (OrderBy)new OrderByImpl(updatedSearchSorts), original.getQueryString());
    }

    private SearchSort enrichPropertyInformation(Map<String, Map<String, IndexDocumentConfiguration.Type>> propKeyToPathToTypes, SearchSort origSS) {
        if (!origSS.getProperty().isDefined()) {
            return origSS;
        }
        Property newProp = this.newPropWithTypeInfo((Property)origSS.getProperty().get(), propKeyToPathToTypes);
        return new SearchSort(origSS.getField(), Option.some((Object)newProp), origSS.getSortOrder());
    }

    private Property newPropWithTypeInfo(Property origProp, Map<String, Map<String, IndexDocumentConfiguration.Type>> propKeyToPathToTypes) {
        IndexDocumentConfiguration.Type propType = propKeyToPathToTypes.getOrDefault(origProp.getKeysAsString(), Collections.emptyMap()).getOrDefault(origProp.getObjectReferencesAsString().toLowerCase(), IndexDocumentConfiguration.Type.STRING);
        return new Property(origProp.getKeys(), origProp.getObjectReferences(), propType);
    }

    private Map<String, Map<String, IndexDocumentConfiguration.Type>> getPropertyKeysToPathsToTypes() {
        Iterable<PluginIndexConfiguration> pluginConfigs = this.pluginIndexConfigurationManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        HashMap<String, Map<String, IndexDocumentConfiguration.Type>> propKeyToPathToTypes = new HashMap<String, Map<String, IndexDocumentConfiguration.Type>>();
        for (PluginIndexConfiguration pConfig : pluginConfigs) {
            for (IndexDocumentConfiguration.KeyConfiguration keyConfig : pConfig.getIndexDocumentConfiguration().getKeyConfigurations()) {
                for (IndexDocumentConfiguration.ExtractConfiguration eConfig : keyConfig.getExtractorConfigurations()) {
                    propKeyToPathToTypes.computeIfAbsent(keyConfig.getPropertyKey(), key -> new HashMap()).put(eConfig.getPath().toLowerCase(), eConfig.getType());
                }
            }
        }
        return propKeyToPathToTypes;
    }
}

