/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.search.quicksearch.PrefixedSingleWordQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandlerImpl;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.MultiValueMap;

public class ComponentQuickSearchHandler
extends PrefixedSingleWordQuickSearchHandler {
    private static final String PREFIX = "c:";
    private final ProjectComponentManager projectComponentManager;
    private final ProjectAwareQuickSearchHandler projectAwareQuickSearchHandler;

    public ComponentQuickSearchHandler(ProjectComponentManager projectComponentManager, ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectComponentManager = projectComponentManager;
        this.projectAwareQuickSearchHandler = new ProjectAwareQuickSearchHandlerImpl(projectManager, permissionManager, authenticationContext);
    }

    @Override
    protected Map handleWordSuffix(String wordSuffix, QuickSearchResult searchResult) {
        List<Project> possibleProjects = this.projectAwareQuickSearchHandler.getProjects(searchResult);
        String projectId = this.projectAwareQuickSearchHandler.getSingleProjectIdFromSearch(searchResult);
        boolean hasProjectInSearch = projectId != null;
        ArrayList projectsWithComponents = Lists.newArrayList();
        MultiValueMap components = new MultiValueMap();
        for (Project possibleProject : possibleProjects) {
            this.getComponentsByName(possibleProject, wordSuffix, components, hasProjectInSearch, projectsWithComponents);
        }
        if (projectsWithComponents.size() == 1) {
            String singleProjectWithComponents = (String)projectsWithComponents.get(0);
            this.projectAwareQuickSearchHandler.addProject(singleProjectWithComponents, searchResult);
        }
        return components;
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    private void getComponentsByName(Project project, String word, MultiValueMap components, boolean hasProjectInSearch, List<String> projectsWithComponents) {
        Collection projectComponents = this.projectComponentManager.findAllForProject(project.getId());
        Set<String> matchingComponents = this.getAllNamesMatchingSubstring(projectComponents, word);
        for (String component : matchingComponents) {
            if (components.containsValue((Object)"component", (Object)component)) continue;
            components.put((Object)"component", (Object)component);
        }
        if (!hasProjectInSearch && !matchingComponents.isEmpty()) {
            projectsWithComponents.add(project.getId().toString());
        }
    }

    protected Set<String> getAllNamesMatchingSubstring(Collection projectComponents, String name) {
        LinkedHashSet matchingComponents = Sets.newLinkedHashSet();
        for (Object projectComponent1 : projectComponents) {
            ProjectComponent projectComponent = (ProjectComponent)projectComponent1;
            String componentName = projectComponent.getName();
            if (componentName == null) continue;
            StringTokenizer st = new StringTokenizer(componentName, " ");
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (!name.equalsIgnoreCase(word)) continue;
                matchingComponents.add(projectComponent.getName());
            }
        }
        return matchingComponents;
    }
}

