/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import com.atlassian.jira.timezone.TimeZoneManager;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateTime;

public abstract class LocalDateQuickSearchHandler
extends SingleWordQuickSearchHandler {
    private final TimeZoneManager timeZoneManager;

    protected LocalDateQuickSearchHandler(TimeZoneManager timeZoneManager) {
        this.timeZoneManager = timeZoneManager;
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        String prefix = this.getPrefix();
        if (word == null || word.length() <= prefix.length() || !word.startsWith(prefix)) {
            return null;
        }
        word = word.substring(prefix.length());
        DateTime now = new DateTime();
        String datePickerToday = LocalDateFactory.getLocalDate((Date)now.toDate(), (TimeZone)this.timeZoneManager.getLoggedInUserTimeZone()).toString();
        String datePickerTomorrow = LocalDateFactory.getLocalDate((Date)now.plusDays(1).toDate(), (TimeZone)this.timeZoneManager.getLoggedInUserTimeZone()).toString();
        String datePickerYesterday = LocalDateFactory.getLocalDate((Date)now.minusDays(1).toDate(), (TimeZone)this.timeZoneManager.getLoggedInUserTimeZone()).toString();
        String paramName = this.getSearchParamName();
        String paramAfter = paramName + ":after";
        String paramPrevious = paramName + ":previous";
        String paramNext = paramName + ":next";
        String paramEquals = paramName + ":equals";
        if ("today".equals(word)) {
            return EasyMap.build((Object)paramEquals, (Object)datePickerToday);
        }
        if ("yesterday".equals(word)) {
            return EasyMap.build((Object)paramEquals, (Object)datePickerYesterday);
        }
        if ("tomorrow".equals(word)) {
            return EasyMap.build((Object)paramEquals, (Object)datePickerTomorrow);
        }
        if (word.indexOf(44) != -1) {
            String firstTerm = word.substring(0, word.indexOf(44));
            String secondTerm = word.substring(word.indexOf(44) + 1);
            return EasyMap.build((Object)paramPrevious, (Object)firstTerm, (Object)paramNext, (Object)secondTerm);
        }
        return EasyMap.build((Object)paramPrevious, (Object)word);
    }

    protected abstract String getPrefix();

    protected abstract String getSearchParamName();
}

