/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import java.util.Collection;
import java.util.Map;

public class PriorityQuickSearchHandler
extends SingleWordQuickSearchHandler {
    public final ConstantsManager constantsManager;

    public PriorityQuickSearchHandler(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        IssueConstant priorityByName = this.getPriorityByName(word);
        return priorityByName != null ? EasyMap.build((Object)"priority", (Object)priorityByName.getId()) : null;
    }

    private IssueConstant getPriorityByName(String name) {
        Collection statuses = this.constantsManager.getPriorities();
        return PriorityQuickSearchHandler.getIssueConstantByName(statuses, name);
    }
}

