/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.PrefixedSingleWordQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandlerImpl;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.RegexpUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.collections.MultiHashMap;

public abstract class VersionQuickSearchHandler
extends PrefixedSingleWordQuickSearchHandler {
    private final VersionManager versionManager;
    private final ProjectAwareQuickSearchHandler projectAwareQuickSearchHandler;

    public VersionQuickSearchHandler(VersionManager versionManager, ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.versionManager = versionManager;
        this.projectAwareQuickSearchHandler = new ProjectAwareQuickSearchHandlerImpl(projectManager, permissionManager, authenticationContext);
    }

    @Override
    protected Map handleWordSuffix(String versionRegexp, QuickSearchResult searchResult) {
        MultiHashMap versions = new MultiHashMap();
        List<Project> possibleProjects = this.projectAwareQuickSearchHandler.getProjects(searchResult);
        String projectId = this.projectAwareQuickSearchHandler.getSingleProjectIdFromSearch(searchResult);
        boolean hasProjectInSearch = projectId != null;
        ArrayList projectsWithVersions = Lists.newArrayListWithCapacity((int)possibleProjects.size());
        for (Project possibleProject : possibleProjects) {
            Set<String> projectVersions = VersionQuickSearchHandler.getAllVersionNamesMatchingSubstring(this.versionManager.getVersions(possibleProject), versionRegexp);
            for (String version : projectVersions) {
                if (versions.containsValue((Object)this.getSearchParamName(), (Object)version)) continue;
                versions.put((Object)this.getSearchParamName(), (Object)version);
            }
            if (hasProjectInSearch || projectVersions.isEmpty()) continue;
            projectsWithVersions.add(possibleProject.getId().toString());
        }
        if (projectsWithVersions.size() == 1) {
            String singleProjectWithVersions = (String)projectsWithVersions.get(0);
            this.projectAwareQuickSearchHandler.addProject(singleProjectWithVersions, searchResult);
        }
        return versions;
    }

    public static Set<String> getAllVersionNamesMatchingSubstring(Collection<Version> versions, String name) {
        LinkedHashSet versionNamesThatMatch = Sets.newLinkedHashSet();
        Pattern p = null;
        if (name.contains("*") || name.contains("?")) {
            p = Pattern.compile(RegexpUtils.wildcardToRegex((String)name));
        }
        for (Version version : versions) {
            String versionName = version.getName();
            if (versionName == null) continue;
            if (p != null) {
                if (!p.matcher(versionName).matches()) continue;
                versionNamesThatMatch.add(version.getName());
                continue;
            }
            StringTokenizer st = new StringTokenizer(versionName, " ");
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (!name.equalsIgnoreCase(word)) continue;
                versionNamesThatMatch.add(version.getName());
            }
        }
        return versionNamesThatMatch;
    }

    @Override
    protected abstract String getPrefix();

    protected abstract String getSearchParamName();
}

