/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.IssueLinkIndexer;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.IssueLinkTypesSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.IssueLinkTypesSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.validator.IssueLinkTypesClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.values.IssueLinkTypesClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Collections;

public class IssueLinkTypesSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public IssueLinkTypesSearcher(VelocityRequestContextFactory contextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, FieldFlagOperandRegistry fieldFlagOperandRegistry, IssueLinkTypesClauseValuesGenerator issueLinkTypesClauseValuesGenerator, IssueLinkTypeManager issueLinkTypeManager, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext) {
        SimpleFieldSearchConstants constants = SystemSearchConstants.forIssueLinkTypes();
        this.searcherInformation = new GenericSearcherInformation(constants.getSearcherId(), "issue.field.issuelinktypes", Collections.singletonList(IssueLinkIndexer.class), this.fieldReference, SearcherGroupType.ISSUE);
        IssueLinkTypesClauseValidator issueLinkTypesClauseValidator = new IssueLinkTypesClauseValidator(operandResolver, issueLinkTypeManager, new SupportedOperatorsValidator(new Collection[]{SystemSearchConstants.forIssueLinkTypes().getSupportedOperators()}));
        this.searchInputTransformer = new IssueLinkTypesSearchInputTransformer(fieldFlagOperandRegistry, operandResolver, issueLinkTypesClauseValidator);
        this.searchRenderer = new IssueLinkTypesSearchRenderer(constants, contextFactory, fieldVisibilityManager, applicationProperties, templatingEngine, this.searcherInformation.getNameKey(), issueLinkTypesClauseValuesGenerator, authenticationContext);
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

