/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.search.parameters.lucene.CachedWrappedQueryCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.search.util.PermissionQueryCache;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionQueryCache
implements PermissionQueryCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionQueryCache.class);
    private final PermissionsFilterGenerator permissionsFilterGenerator;

    public DefaultPermissionQueryCache(PermissionsFilterGenerator permissionsFilterGenerator) {
        this.permissionsFilterGenerator = permissionsFilterGenerator;
    }

    @Override
    public Optional<Query> getPermissionQuery(ApplicationUser searchUser) {
        return this.getPermissionQuery(searchUser, null);
    }

    @Override
    public Optional<Query> getPermissionQuery(ApplicationUser searchUser, @Nullable Collection<Project> projects) {
        this.enablePermissionFilterCachingFlagWhenDoingMultipleSearches();
        if (this.getEnabledCachedWrapperFlag().booleanValue()) {
            CachedWrappedQueryCache cache = this.getCachedWrappedFilterCache();
            Query query = cache.getQuery(searchUser, projects);
            if (query != null) {
                return Optional.of(query);
            }
            Query permissionQuery = this.permissionsFilterGenerator.getQuery(searchUser, projects);
            cache.storeQuery(permissionQuery, searchUser, projects);
            return Optional.of(permissionQuery);
        }
        return Optional.empty();
    }

    @Override
    public void disableCacheForRequest() {
        JiraAuthenticationContextImpl.getRequestCache().put("jira.wrap.ermission.filer.in.cached.wrapper.cache.skip", Boolean.TRUE);
    }

    private void enablePermissionFilterCachingFlagWhenDoingMultipleSearches() {
        if (this.getEnabledCachedWrapperFlagSkip().booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Caching wrapper for permission filter is disabled for this request");
            }
            return;
        }
        Integer searchCounter = (Integer)JiraAuthenticationContextImpl.getRequestCache().get("filter.usage.count");
        if (searchCounter == null) {
            JiraAuthenticationContextImpl.getRequestCache().put("filter.usage.count", 1);
            return;
        }
        if (searchCounter == 1 && !this.getEnabledCachedWrapperFlag().booleanValue()) {
            JiraAuthenticationContextImpl.getRequestCache().put("jira.wrap.ermission.filer.in.cached.wrapper.cache", Boolean.TRUE);
            if (log.isDebugEnabled()) {
                log.debug("Caching wrapper for permission filter was enabled, because more than one search during single request was performed");
            }
        }
        this.countAndLogSearchesInDevMode();
    }

    private void countAndLogSearchesInDevMode() {
        if (JiraSystemProperties.getInstance().isDevMode()) {
            Integer devSearchCounter = (Integer)JiraAuthenticationContextImpl.getRequestCache().get("devmode.filter.usage.count");
            Integer devNewSearchCounter = devSearchCounter == null ? 1 : devSearchCounter + 1;
            JiraAuthenticationContextImpl.getRequestCache().put("devmode.filter.usage.count", devNewSearchCounter);
            if (devSearchCounter != null && devSearchCounter >= 2 && !this.getEnabledCachedWrapperFlag().booleanValue()) {
                log.warn("This request asked for permission filter " + devNewSearchCounter + " times already and RequestCacheKeys.WRAP_PERMISSION_FILTER_IN_CACHED_WRAPPER_CACHE flag is set to 'false' while it should be set to 'true'");
            }
        }
    }

    private Boolean getEnabledCachedWrapperFlag() {
        return this.getBooleanFromRequestCache("jira.wrap.ermission.filer.in.cached.wrapper.cache");
    }

    private Boolean getEnabledCachedWrapperFlagSkip() {
        return this.getBooleanFromRequestCache("jira.wrap.ermission.filer.in.cached.wrapper.cache.skip");
    }

    private Boolean getBooleanFromRequestCache(String wrapPermissionFilterInCachedWrapperCache) {
        Boolean flag = (Boolean)JiraAuthenticationContextImpl.getRequestCache().get(wrapPermissionFilterInCachedWrapperCache);
        return flag == null ? Boolean.FALSE : flag;
    }

    private CachedWrappedQueryCache getCachedWrappedFilterCache() {
        CachedWrappedQueryCache cache = (CachedWrappedQueryCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.cached.wrapped.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new CachedWrappedQueryCache");
            }
            cache = new CachedWrappedQueryCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.cached.wrapped.filter.cache", cache);
        }
        return cache;
    }
}

