/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.util.FreeTextVisitor;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchSortUtilImpl
implements SearchSortUtil {
    private static final Logger log = LoggerFactory.getLogger(SearchSortUtilImpl.class);
    private final SearchHandlerManager searchHandlerManager;
    private final FieldManager fieldManager;
    static final SearchSort DEFAULT_KEY_SORT = new SearchSort(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), SortOrder.DESC);

    public SearchSortUtilImpl(SearchHandlerManager searchHandlerManager, FieldManager fieldManager) {
        this.searchHandlerManager = searchHandlerManager;
        this.fieldManager = fieldManager;
    }

    public List<SearchSort> concatSearchSorts(Collection<SearchSort> newSorts, Collection<SearchSort> oldSorts, int maxLength) {
        Assertions.notNull((String)"newSorts", newSorts);
        Iterator source = newSorts.iterator();
        if (oldSorts != null) {
            source = IteratorUtils.chainedIterator(source, oldSorts.iterator());
        }
        ArrayList<SearchSort> calcSorts = new ArrayList<SearchSort>();
        while (calcSorts.size() < maxLength && source.hasNext()) {
            calcSorts.add((SearchSort)source.next());
        }
        return calcSorts;
    }

    public List<SearchSort> mergeSearchSorts(ApplicationUser user, Collection<SearchSort> newSorts, Collection<SearchSort> oldSorts, int maxLength) {
        Assertions.notNull((String)"newSorts", newSorts);
        Iterator source = newSorts.iterator();
        if (oldSorts != null) {
            newSorts = this.convertNewSortsToKeepOldSortNames(user, newSorts, oldSorts);
            source = IteratorUtils.chainedIterator(newSorts.iterator(), oldSorts.iterator());
        }
        HashSet currentPrimaryClauseNames = new HashSet();
        ArrayList<SearchSort> calcSorts = new ArrayList<SearchSort>();
        while ((maxLength <= 0 || calcSorts.size() < maxLength) && source.hasNext()) {
            final SearchSort sort = (SearchSort)source.next();
            Collection handlers = this.searchHandlerManager.getClauseHandler(user, sort.getField());
            ArrayList primaryClauseNames = new ArrayList(CollectionUtil.transform(handlers.iterator(), (Function)new Function<ClauseHandler, String>(){

                public String apply(ClauseHandler handler) {
                    return handler.getInformation().getJqlClauseNames().getPrimaryName();
                }
            }));
            Collections.sort(primaryClauseNames);
            if (Collections.disjoint(currentPrimaryClauseNames, primaryClauseNames)) {
                calcSorts.add(sort);
                currentPrimaryClauseNames.addAll(primaryClauseNames);
                continue;
            }
            Collection primaryClauseNamesNotYetUsed = CollectionUtils.subtract(primaryClauseNames, currentPrimaryClauseNames);
            calcSorts.addAll(CollectionUtil.transform(primaryClauseNamesNotYetUsed.iterator(), (Function)new Function<String, SearchSort>(){

                public SearchSort apply(String clauseName) {
                    return new SearchSort(clauseName, sort.getSortOrder());
                }
            }));
            currentPrimaryClauseNames.addAll(primaryClauseNamesNotYetUsed);
        }
        return calcSorts;
    }

    Collection<SearchSort> convertNewSortsToKeepOldSortNames(ApplicationUser user, Collection<SearchSort> newSorts, Collection<SearchSort> oldSorts) {
        ArrayList convertedSorts = Lists.newArrayListWithCapacity((int)newSorts.size());
        for (SearchSort newSort : newSorts) {
            Collection newHandlers = this.searchHandlerManager.getClauseHandler(user, newSort.getField());
            if (newHandlers.size() != 1) {
                convertedSorts.add(newSort);
                continue;
            }
            ClauseHandler newHandler = (ClauseHandler)newHandlers.iterator().next();
            SearchSort convertedSort = newSort;
            for (SearchSort oldSort : oldSorts) {
                Collection oldHandlers = this.searchHandlerManager.getClauseHandler(user, oldSort.getField());
                if (oldHandlers.size() != 1) continue;
                ClauseHandler handler = (ClauseHandler)oldHandlers.iterator().next();
                if (!newHandler.getInformation().getJqlClauseNames().equals((Object)handler.getInformation().getJqlClauseNames()) || newSort.getField().equals(oldSort.getField())) continue;
                convertedSort = new SearchSort(oldSort.getField(), newSort.getSortOrder());
            }
            convertedSorts.add(convertedSort);
        }
        return convertedSorts;
    }

    public List<SearchSort> getSearchSorts(Query query) {
        List<SearchSort> sorts;
        if (query == null) {
            sorts = Collections.emptyList();
        } else {
            if (query.getOrderByClause() == null) {
                return null;
            }
            sorts = query.getOrderByClause().getSearchSorts();
        }
        if (sorts.isEmpty() && (query == null || !FreeTextVisitor.containsFreeTextCondition(query.getWhereClause()))) {
            sorts = Collections.singletonList(DEFAULT_KEY_SORT);
        }
        return sorts;
    }

    public OrderBy getOrderByClause(Map parameterMap) {
        List orders = ParameterUtils.getListParam((Map)parameterMap, (String)"sorter/order");
        List fields = ParameterUtils.getListParam((Map)parameterMap, (String)"sorter/field");
        int minLength = orders == null || fields == null ? 0 : Math.min(orders.size(), fields.size());
        ArrayList searchSorts = Lists.newArrayListWithCapacity((int)minLength);
        for (int i = 0; i < minLength; ++i) {
            String order = (String)orders.get(i);
            String field = (String)fields.get(i);
            if (order == null || field == null) continue;
            Collection matchingClauseNames = this.searchHandlerManager.getJqlClauseNames(field);
            if (!matchingClauseNames.isEmpty()) {
                if (this.fieldManager.isNavigableField(field)) {
                    ClauseNames names = (ClauseNames)matchingClauseNames.iterator().next();
                    searchSorts.add(new SearchSort(order, names.getPrimaryName()));
                    continue;
                }
                log.warn("Unable to create a search sort for the field name '" + field + "' as the field is able to be sorted.");
                continue;
            }
            log.warn("Unable to create a search sort for field name '" + field + "' as there is no associated JQL clause name.");
        }
        return new OrderByImpl((Collection)searchSorts);
    }

    public List<String> getSearchSortDescriptions(SearchRequest searchRequest, I18nHelper i18nHelper, ApplicationUser searcher) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        ArrayList<String> searchSortDescriptions = new ArrayList<String>();
        List<SearchSort> searchSorts = this.getSearchSorts(searchRequest.getQuery());
        for (SearchSort searchSort : searchSorts) {
            String sortClauseName = searchSort.getField();
            ArrayList fieldIds = new ArrayList(this.searchHandlerManager.getFieldIds(searcher, sortClauseName));
            Collections.sort(fieldIds);
            for (String fieldId : fieldIds) {
                Field field = this.fieldManager.getField(fieldId);
                if (field != null) {
                    StringBuilder description = new StringBuilder();
                    description.append(i18nHelper.getText(field.getNameKey()));
                    String orderDescription = SearchSortUtilImpl.getSearchSortOrderDescription(searchSort.getOrder(), field, i18nHelper);
                    if (!StringUtils.isBlank((CharSequence)orderDescription)) {
                        description.append(" ").append(orderDescription);
                    }
                    searchSortDescriptions.add(description.toString());
                    continue;
                }
                log.info("Field '" + sortClauseName + "' is invalid as a search sort in SearchRequest " + searchRequest);
            }
        }
        for (int i = 0; i < searchSortDescriptions.size(); ++i) {
            String description = (String)searchSortDescriptions.get(i);
            if (i >= searchSortDescriptions.size() - 1) continue;
            String newDescription = description + ", " + i18nHelper.getText("navigator.hidden.sortby.then");
            searchSortDescriptions.set(i, newDescription);
        }
        return searchSortDescriptions;
    }

    private static String getSearchSortOrderDescription(String searchSortOrder, Field field, I18nHelper i18nHelper) {
        if (!(field instanceof NavigableField)) {
            return "";
        }
        NavigableField navigableField = (NavigableField)field;
        String string = searchSortOrder = StringUtils.isBlank((CharSequence)searchSortOrder) ? navigableField.getDefaultSortOrder() : searchSortOrder;
        if ("DESC".equals(searchSortOrder)) {
            return i18nHelper.getText("navigator.hidden.sortby.descending");
        }
        return i18nHelper.getText("navigator.hidden.sortby.ascending");
    }
}

