/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelUpdatedEvent;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelImpl;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.function.Function;
import java.util.function.Supplier;

public class IssueSecurityLevelServiceImpl
implements IssueSecurityLevelService {
    private final IssueSecurityLevelManager levelManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;
    private final EventPublisher eventPublisher;
    private final int MAX_LEVEL_LENGTH = 255;

    public IssueSecurityLevelServiceImpl(IssueSecurityLevelManager levelManager, GlobalPermissionManager globalPermissionManager, I18nHelper i18n, EventPublisher eventPublisher) {
        this.levelManager = levelManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
    }

    public IssueSecurityLevelService.UpdateValidationResult validateUpdate(ApplicationUser user, IssueSecurityLevel currentLevel, String newName, String newDescription) {
        this.requireNotNull(currentLevel.getId(), "currentLevel.id");
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorCollection(this.validateLevelName(newName));
        errors.addErrorCollection(this.validateDuplicates(currentLevel, newName));
        errors.addErrorCollection(this.validatePermissions(user));
        if (errors.hasAnyErrors()) {
            return new IssueSecurityLevelService.UpdateValidationResult(null, (ErrorCollection)errors);
        }
        return new IssueSecurityLevelService.UpdateValidationResult((IssueSecurityLevel)new IssueSecurityLevelImpl(currentLevel.getId(), newName, newDescription, currentLevel.getSchemeId()), (ErrorCollection)errors);
    }

    public ServiceOutcome<IssueSecurityLevel> update(ApplicationUser callingUser, IssueSecurityLevelService.UpdateValidationResult validationResult) {
        return this.checkIsAdminAndPerform(callingUser, (IssueSecurityLevelService.LevelValidationResult)validationResult, vr -> {
            IssueSecurityLevelUpdatedEvent event = this.buildIssueSecurityLevelEvent(validationResult);
            IssueSecurityLevel issueSecurityLevel = this.levelManager.updateIssueSecurityLevel(vr.getLevel());
            this.eventPublisher.publish((Object)event);
            return new ServiceOutcomeImpl<IssueSecurityLevel>(vr.getErrors(), issueSecurityLevel);
        });
    }

    public IssueSecurityLevelService.CreateValidationResult validateCreate(ApplicationUser user, long schemeId, String name, String description) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorCollection(this.validateLevelName(name));
        errors.addErrorCollection(this.validateDuplicates(name, schemeId));
        errors.addErrorCollection(this.validatePermissions(user));
        if (errors.hasAnyErrors()) {
            return new IssueSecurityLevelService.CreateValidationResult(null, (ErrorCollection)errors);
        }
        return new IssueSecurityLevelService.CreateValidationResult((IssueSecurityLevel)new IssueSecurityLevelImpl(null, name, description, schemeId), (ErrorCollection)errors);
    }

    public ServiceOutcome<IssueSecurityLevel> create(ApplicationUser callingUser, IssueSecurityLevelService.CreateValidationResult validationResult) {
        return this.checkIsAdminAndPerform(callingUser, (IssueSecurityLevelService.LevelValidationResult)validationResult, vr -> new ServiceOutcomeImpl<IssueSecurityLevel>(vr.getErrors(), this.levelManager.createIssueSecurityLevel(vr.getLevel())));
    }

    private boolean isDuplicatedIssueSecurityLevelName(String levelName, Long schemeId) {
        return levelName != null && this.levelManager.getSecurityLevelByNameAndSchema(levelName.trim(), schemeId) != null;
    }

    private boolean isEmptyIssueSecurityLevelName(String levelName) {
        return levelName == null || levelName.trim().isEmpty();
    }

    private boolean isTooLongIssueSecurityLevelName(String levelName) {
        return levelName != null && levelName.length() > 255;
    }

    private ErrorCollection validateLevelName(String levelName) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.isEmptyIssueSecurityLevelName(levelName)) {
            errors.addError("name", this.i18n.getText("admin.errors.specify.name.for.security"));
        }
        if (this.isTooLongIssueSecurityLevelName(levelName)) {
            errors.addError("name", this.i18n.getText("admin.errors.level.name.too.long"));
        }
        return errors;
    }

    private ErrorCollection validateDuplicates(IssueSecurityLevel currentLevel, String newLevelName) {
        if (newLevelName != null && newLevelName.equalsIgnoreCase(currentLevel.getName())) {
            return new SimpleErrorCollection();
        }
        return this.validateDuplicates(newLevelName, currentLevel.getSchemeId());
    }

    private ErrorCollection validatePermissions(ApplicationUser user) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.isAdmin(user)) {
            String forbiddenMessage = this.i18n.getText("admin.schemes.permissions.forbidden");
            errors.addErrorMessage(forbiddenMessage);
        }
        return errors;
    }

    private ErrorCollection validateDuplicates(String newLevelName, long schemeId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.isDuplicatedIssueSecurityLevelName(newLevelName, schemeId)) {
            errors.addError("name", this.i18n.getText("admin.errors.security.level.with.name.already.exists"));
        }
        return errors;
    }

    private <T> ServiceOutcome<T> checkIsAdminAndPerform(ApplicationUser callingUser, IssueSecurityLevelService.LevelValidationResult validationResult, Function<IssueSecurityLevelService.LevelValidationResult, ServiceOutcome<T>> actionOnValidationResult) {
        this.requireNotNull(validationResult, "validationResult");
        if (!validationResult.isValid()) {
            throw new IllegalStateException("You can not create an IssueSecurityLevel with an invalid validation result.");
        }
        return this.checkPermissionsPerformAction(callingUser, (Predicate<ApplicationUser>)((Predicate)user -> this.isAdmin((ApplicationUser)user)), () -> (ServiceOutcome)actionOnValidationResult.apply(validationResult));
    }

    private void requireNotNull(Object toCheck, String toCheckName) {
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("%s can't be null.", toCheckName));
        }
    }

    private <T> ServiceOutcome<T> checkPermissionsPerformAction(ApplicationUser user, Predicate<ApplicationUser> hasPermissions, Supplier<ServiceOutcome<T>> action) {
        String forbiddenMessage = this.i18n.getText("admin.schemes.permissions.forbidden");
        if (user == null) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        if (!hasPermissions.evaluate((Object)user)) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.FORBIDDEN);
        }
        return action.get();
    }

    private boolean isAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private IssueSecurityLevelUpdatedEvent buildIssueSecurityLevelEvent(IssueSecurityLevelService.UpdateValidationResult validationResult) {
        Long id = validationResult.getLevel().getId();
        IssueSecurityLevel oldValue = this.levelManager.getSecurityLevel(id.longValue());
        return new IssueSecurityLevelUpdatedEvent(validationResult.getLevel().getName(), oldValue.getName(), validationResult.getLevel().getDescription(), oldValue.getDescription(), oldValue.getSchemeId());
    }
}

