/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;

public class OneDimensionalObjectHitCollector
extends SimpleCollector {
    private StatisticsMapper statisticsMapper;
    private final Map<Object, Integer> result;
    private final String fieldName;
    private NumericDocValues docValues;
    private int docBase = 0;

    public OneDimensionalObjectHitCollector(String fieldName, StatisticsMapper statisticsMapper, Map result) {
        this(fieldName, statisticsMapper, result, false);
    }

    @ExperimentalApi
    public OneDimensionalObjectHitCollector(String fieldName, StatisticsMapper statisticsMapper, Map result, boolean isUnique) {
        this.fieldName = fieldName;
        this.result = result;
        this.statisticsMapper = statisticsMapper;
    }

    public void collect(int i) throws IOException {
        this.docValues.advanceExact(i);
        this.adjustMapForValues(this.result, this.docValues.longValue());
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
        String fieldId = this.statisticsMapper.getDocumentConstant();
        this.docValues = context.reader().getNumericDocValues(this.fieldName);
    }

    private void adjustMapForValues(Map<Object, Integer> map, long value) {
        Object object;
        Integer count = map.get(object = this.getValueForField(value));
        map.put(object, count == null ? 1 : count + 1);
    }

    private Object getValueForField(Long term) {
        return this.statisticsMapper.getValueFromLuceneField(term.toString());
    }

    public boolean needsScores() {
        return false;
    }
}

