/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.status.ClearStatusCacheEvent;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusFormatter;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultStatusFormatter
implements StatusFormatter {
    private static final Logger log = LoggerFactory.getLogger(DefaultStatusFormatter.class);
    private static final String CACHE_KEY = DefaultStatusFormatter.class.getName() + ".statuses";
    private final VelocityTemplatingEngine templatingEngine;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;

    public DefaultStatusFormatter(VelocityTemplatingEngine templatingEngine, SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.templatingEngine = templatingEngine;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    @Nonnull
    protected LoadingCache<ImmutableMap<String, Object>, String> getRequestCache() {
        return (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(CACHE_KEY, () -> CacheBuilder.newBuilder().build(CacheLoader.from(params -> {
            HashMap velocityParams = Maps.newHashMap((Map)params);
            velocityParams.put("soyRenderer", this.soyTemplateRendererProvider.getRenderer());
            return this.renderTemplate("status-columnview.vm", velocityParams);
        })));
    }

    @Override
    @Nonnull
    public String getColumnViewHtml(@Nullable Status status, @Nonnull Map<String, Object> displayParams) {
        return this.getColumnViewHtml(status != null ? status.getSimpleStatus() : null, displayParams);
    }

    @Override
    @Nonnull
    public String getColumnViewHtml(@Nullable SimpleStatus status, @Nonnull Map<String, Object> displayParams) {
        ImmutableMap.Builder velocityParams = ImmutableMap.builder().putAll(displayParams);
        if (status != null) {
            velocityParams.put((Object)"status", (Object)status);
        }
        return StringUtils.defaultString((String)((String)this.getRequestCache().getUnchecked((Object)velocityParams.build())), (String)"");
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.refresh();
    }

    @EventListener
    public void onClearStatusCacheEvent(ClearStatusCacheEvent ignored) {
        this.refresh();
    }

    private void refresh() {
        this.getRequestCache().invalidateAll();
    }

    protected String renderTemplate(String template, Map<String, Object> velocityParams) {
        try {
            return this.templatingEngine.render(TemplateSources.file((String)("templates/jira/issue/field/" + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error occurred while rendering velocity template for 'templates/jira/issue/field//" + template + "'.", (Throwable)e);
            return "";
        }
    }
}

