/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.subscription;

import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.issue.subscription.DefaultFilterSubscription;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.ofbiz.FieldMap;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionFactory
extends AbstractEntityFactory<FilterSubscription> {
    public static final String ID = "id";
    public static final String FILTER_ID = "filterID";
    public static final String USER_KEY = "username";
    public static final String GROUP = "group";
    public static final String LAST_RUN_TIME = "lastRun";
    public static final String EMAIL_ON_EMPTY = "emailOnEmpty";

    @Override
    public String getEntityName() {
        return "FilterSubscription";
    }

    @Override
    public FilterSubscription build(GenericValue gv) {
        return new DefaultFilterSubscription(gv.getLong(ID), gv.getLong(FILTER_ID), gv.getString(USER_KEY), gv.getString(GROUP), gv.getTimestamp(LAST_RUN_TIME), Boolean.valueOf(gv.getString(EMAIL_ON_EMPTY)));
    }

    @Override
    public Map<String, Object> fieldMapFrom(FilterSubscription filterSubscription) {
        return new FieldMap().add(ID, (Object)filterSubscription.getId()).add(FILTER_ID, (Object)filterSubscription.getFilterId()).add(USER_KEY, (Object)filterSubscription.getUserKey()).add(GROUP, (Object)filterSubscription.getGroupName()).add(LAST_RUN_TIME, (Object)FilterSubscriptionFactory.toTimestamp(filterSubscription.getLastRunTime())).add(EMAIL_ON_EMPTY, (Object)String.valueOf(filterSubscription.isEmailOnEmpty()));
    }

    private static Timestamp toTimestamp(Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }
}

