/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.issue.tabpanels.ActionExpanderFactory;
import com.atlassian.jira.issue.tabpanels.ActionExpanderProvider;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.TabPanelOrder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ActionExpanderProviderImpl
implements ActionExpanderProvider {
    private static final int FIRST = 0;
    private final ActionExpanderFactory actionExpanderFactory;

    public ActionExpanderProviderImpl(ActionExpanderFactory actionExpanderFactory) {
        this.actionExpanderFactory = actionExpanderFactory;
    }

    public List<IssueAction> addExpanders(Page<IssueAction> page, GetActionsRequest request, TabPanelOrder order, IssueTabPanelModuleDescriptor descriptor) {
        ArrayList actions = Lists.newArrayList();
        this.topExpander(page, request, order, descriptor).ifPresent(actions::add);
        actions.addAll(page.getPageContents());
        this.bottomExpander(page, request, order, descriptor).ifPresent(actions::add);
        return actions;
    }

    private Optional<IssueAction> topExpander(Page<IssueAction> page, GetActionsRequest request, TabPanelOrder order, IssueTabPanelModuleDescriptor descriptor) {
        Optional<Date> date = this.getTimePerformedOfElement(page, 0);
        if (!page.isFirstPage() && date.isPresent()) {
            if (order == TabPanelOrder.OLDEST_FIRST) {
                return Optional.of(this.actionExpanderFactory.getOlderActionsExpander(descriptor, request.issue().getKey(), date.get(), order));
            }
            return Optional.of(this.actionExpanderFactory.getNewerActionsExpander(descriptor, request.issue().getKey(), date.get(), order));
        }
        return Optional.empty();
    }

    private Optional<IssueAction> bottomExpander(Page<IssueAction> page, GetActionsRequest request, TabPanelOrder order, IssueTabPanelModuleDescriptor descriptor) {
        Optional<Date> date = this.getTimePerformedOfElement(page, page.getPageContents().size() - 1);
        if (!page.isLastPage() && date.isPresent()) {
            if (order == TabPanelOrder.OLDEST_FIRST) {
                return Optional.of(this.actionExpanderFactory.getNewerActionsExpander(descriptor, request.issue().getKey(), date.get(), order));
            }
            return Optional.of(this.actionExpanderFactory.getOlderActionsExpander(descriptor, request.issue().getKey(), date.get(), order));
        }
        return Optional.empty();
    }

    private Optional<Date> getTimePerformedOfElement(Page<IssueAction> page, int elementIndex) {
        if (page.getPageContents().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(((IssueAction)page.getPageContents().get(elementIndex)).getTimePerformed());
        }
        catch (UnsupportedOperationException uoe) {
            return Optional.empty();
        }
    }
}

