/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistorySearcher;
import com.atlassian.jira.issue.changehistory.ChangeHistoryUsernameResolver;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.changehistory.metadata.renderer.HistoryMetadataRenderHelper;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.issue.tabpanels.ChangeHistoryAction;
import com.atlassian.jira.issue.tabpanels.IssueCreatedAction;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.Window;
import java.util.ArrayList;
import java.util.List;

public class ChangeHistoryTabPanel
implements PaginatedIssueTabPanel {
    private final ChangeHistorySearcher changeHistorySearcher;
    private final AttachmentManager attachmentManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final CustomFieldManager customFieldManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final DateTimeFieldChangeLogHelper changeLogHelper;
    private final UserFormatManager userFormatManager;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final HistoryMetadataManager historyMetadataManager;
    private final HistoryMetadataRenderHelper historyMetadataRenderHelper;
    private final ChangeHistoryUsernameResolver changeHistoryUsernameResolver;
    private IssueTabPanelModuleDescriptor descriptor;

    public ChangeHistoryTabPanel(ChangeHistorySearcher changeHistorySearcher, AttachmentManager attachmentManager, JiraDurationUtils jiraDurationUtils, CustomFieldManager customFieldManager, DateTimeFormatterFactory dateTimeFormatterFactory, DateTimeFieldChangeLogHelper changeLogHelper, UserFormatManager userFormatManager, I18nHelper i18nHelper, JiraAuthenticationContext authenticationContext, AvatarService avatarService, HistoryMetadataManager historyMetadataManager, HistoryMetadataRenderHelper historyMetadataRenderHelper, ChangeHistoryUsernameResolver changeHistoryUsernameResolver) {
        this.changeHistorySearcher = changeHistorySearcher;
        this.attachmentManager = attachmentManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.customFieldManager = customFieldManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.changeLogHelper = changeLogHelper;
        this.userFormatManager = userFormatManager;
        this.i18nHelper = i18nHelper;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.historyMetadataManager = historyMetadataManager;
        this.historyMetadataRenderHelper = historyMetadataRenderHelper;
        this.changeHistoryUsernameResolver = changeHistoryUsernameResolver;
    }

    public Page<IssueAction> getActions(GetActionsRequest request) {
        final Window<ChangeHistory> filteredHistory = this.getChangeHistories(request);
        final List<IssueAction> actions = this.convertToActions(request, filteredHistory);
        return new Page<IssueAction>(){

            public boolean isFirstPage() {
                return !filteredHistory.hasElementsBefore();
            }

            public boolean isLastPage() {
                return !filteredHistory.hasElementsAfter();
            }

            public List<IssueAction> getPageContents() {
                return actions;
            }
        };
    }

    private List<IssueAction> convertToActions(GetActionsRequest request, Window<ChangeHistory> history) {
        ArrayList<IssueAction> actions = new ArrayList<IssueAction>();
        if (!history.hasElementsBefore()) {
            actions.add(this.getIssueCreatedAction(request.issue()));
        }
        for (ChangeHistory item : history) {
            actions.add((IssueAction)this.createHistoryAction(request, item));
        }
        return actions;
    }

    private IssueAction getIssueCreatedAction(Issue issue) {
        return new IssueCreatedAction(this.descriptor, this.dateTimeFormatterFactory.formatter().forLoggedInUser(), this.userFormatManager, this.i18nHelper, this.avatarService, this.authenticationContext, issue);
    }

    private ChangeHistoryAction createHistoryAction(GetActionsRequest request, ChangeHistory changeHistoryItem) {
        HistoryMetadataManager.HistoryMetadataResult historyMetadata = this.historyMetadataManager.getHistoryMetadata(changeHistoryItem, request.remoteUser());
        return new ChangeHistoryAction(this.descriptor, changeHistoryItem, false, this.attachmentManager, this.jiraDurationUtils, this.customFieldManager, this.dateTimeFormatterFactory.formatter().forLoggedInUser(), request.issue(), this.changeLogHelper, historyMetadata.getHistoryMetadata(), this.historyMetadataRenderHelper, this.changeHistoryUsernameResolver);
    }

    private Window<ChangeHistory> getChangeHistories(GetActionsRequest request) {
        ChangeHistorySearcher.OngoingSearch finalSearch;
        ChangeHistorySearcher.UnboundSearch searchByIssue = this.changeHistorySearcher.searchForIssue(request.issue());
        GetActionsRequest.FetchMode fetchMode = request.batching().fetchMode();
        if (fetchMode == GetActionsRequest.FetchMode.FROM_OLDEST) {
            finalSearch = searchByIssue.fromBeginning();
        } else if (fetchMode == GetActionsRequest.FetchMode.FROM_NEWEST) {
            finalSearch = searchByIssue.fromEnd();
        } else if (fetchMode == GetActionsRequest.FetchMode.NEWER_THAN_DATE) {
            finalSearch = searchByIssue.since(request.batching().fromDate().toInstant());
        } else if (fetchMode == GetActionsRequest.FetchMode.OLDER_THAN_DATE) {
            finalSearch = searchByIssue.before(request.batching().fromDate().toInstant());
        } else {
            throw new IllegalArgumentException();
        }
        return ChangeHistoryTabPanel.maybeLimit(request, finalSearch).asWindow();
    }

    private static ChangeHistorySearcher.OngoingSearch maybeLimit(GetActionsRequest request, ChangeHistorySearcher.OngoingSearch search) {
        if (!request.isShowAll()) {
            return search.limit(request.batching().limit());
        }
        return search;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    public void init(IssueTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

