/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.webfragment.model.CommentHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraVelocityHelper;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentAction
extends AbstractIssueAction {
    private static final Logger log = LoggerFactory.getLogger(CommentAction.class);
    private final Comment comment;
    private final Issue issue;
    private final boolean canEditComment;
    private final boolean canDeleteComment;
    private final boolean canReact;
    private final boolean commentReactionsEnabled;
    private final boolean isCollapsed;
    private final boolean isHeader;
    private final boolean pinned;
    private final String pinnedBy;
    private final boolean canPin;
    private final Date pinnedAt;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final CommentFieldRenderer commentFieldRenderer;
    private final CommentPropertyService commentPropertyService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public CommentAction(IssueTabPanelModuleDescriptor descriptor, Comment comment, boolean canEditComment, boolean canDeleteComment, boolean canReact, boolean commentReactionsEnabled, boolean isHeader, boolean isCollapsed, boolean isPinned, boolean canPin, String pinnedBy, Date pinnedAt, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, DateTimeFormatter dateTimeFormatter, CommentFieldRenderer commentFieldRenderer, CommentPropertyService commentPropertyService, JiraAuthenticationContext jiraAuthenticationContext) {
        super(descriptor);
        this.comment = comment;
        this.dateTimeFormatter = dateTimeFormatter;
        this.commentFieldRenderer = commentFieldRenderer;
        this.commentPropertyService = commentPropertyService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issue = comment.getIssue();
        this.canEditComment = canEditComment;
        this.canDeleteComment = canDeleteComment;
        this.canReact = canReact;
        this.commentReactionsEnabled = commentReactionsEnabled;
        this.isCollapsed = isCollapsed;
        this.isHeader = isHeader;
        this.pinned = isPinned;
        this.canPin = canPin;
        this.pinnedBy = pinnedBy;
        this.pinnedAt = pinnedAt;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public Date getTimePerformed() {
        return this.comment.getCreated();
    }

    public Date getPinnedAt() {
        return this.pinnedAt;
    }

    protected void populateVelocityParams(Map params) {
        params.put("action", this);
        params.put("velocityhelper", new JiraVelocityHelper(ComponentAccessor.getFieldManager()));
        params.put("requestContext", new DefaultVelocityRequestContextFactory(ComponentAccessor.getApplicationProperties()).getJiraVelocityRequestContext());
        params.put("userformat", ComponentAccessor.getComponent(UserFormatManager.class));
        params.put("textutils", new TextUtils());
        try {
            FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeId()).getFieldLayoutItem("comment");
            if (fieldLayoutItem != null) {
                params.put("renderedContent", this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), this.comment.getBody(), this.issue.getIssueRenderContext()));
            }
        }
        catch (DataAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getHtml() {
        HashMap params = Maps.newHashMap();
        this.populateVelocityParams(params);
        return this.commentFieldRenderer.getIssuePageViewHtml(params, CommentHelper.builder().issue(this.issue).comment(this.comment).build());
    }

    public Comment getComment() {
        return this.comment;
    }

    public List<EntityProperty> getCommentProperties() {
        final ApplicationUser applicationUser = this.jiraAuthenticationContext.getUser();
        Iterable propOptions = Iterables.transform((Iterable)this.commentPropertyService.getPropertiesKeys(applicationUser, this.comment.getId()).getKeys(), (Function)new Function<String, Option<EntityProperty>>(){

            public Option<EntityProperty> apply(String propertyKey) {
                return CommentAction.this.commentPropertyService.getProperty(applicationUser, CommentAction.this.comment.getId(), propertyKey).getEntityProperty();
            }
        });
        return Lists.newArrayList((Iterable)Options.flatten((Iterable)propOptions));
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isCanEditComment() {
        return this.canEditComment;
    }

    public boolean isCanDeleteComment() {
        return this.canDeleteComment;
    }

    public boolean isCanReact() {
        return this.canReact;
    }

    public boolean isCommentReactionsEnabled() {
        return this.commentReactionsEnabled;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isCanPin() {
        return this.canPin;
    }

    public String getPinnedBy() {
        return this.pinnedBy;
    }

    public String formatDisplayHtml(Date date) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter completeFormatter = this.dateTimeFormatter().withStyle(DateTimeStyle.COMPLETE);
        return TextUtils.htmlEncode((String)completeFormatter.format(date));
    }

    public String formatIso8601Html(Date date) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter iso8601Formatter = this.dateTimeFormatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME);
        return TextUtils.htmlEncode((String)iso8601Formatter.format(date));
    }

    protected DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter.forLoggedInUser();
    }
}

