/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabExpanderAction
implements IssueAction {
    private static final Logger log = LoggerFactory.getLogger(TabExpanderAction.class);
    private static final String TEMPLATE = "templates/plugins/jira/issuetabpanels/generic-message.vm";
    private final SoyTemplateRenderer renderer;
    private final Map<String, Object> params;

    private TabExpanderAction(SoyTemplateRenderer renderer, Map<String, Object> params) {
        this.renderer = renderer;
        this.params = params;
    }

    @VisibleForTesting
    protected Map<String, Object> getParams() {
        return this.params;
    }

    public String getHtml() {
        VelocityTemplatingEngine templatingEngine = (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        try {
            return templatingEngine.render(TemplateSources.file((String)TEMPLATE)).applying((Map)ImmutableMap.of((Object)"message", (Object)this.getMessage())).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error while rendering velocity template for 'templates/plugins/jira/issuetabpanels/generic-message.vm'.", (Throwable)e);
            return "Velocity template generation failed.";
        }
    }

    private String getMessage() {
        return this.renderer.render("jira.webresources:soy-templates", this.templateName(), this.params);
    }

    protected abstract String templateName();

    public Date getTimePerformed() {
        throw new UnsupportedOperationException();
    }

    public boolean isDisplayActionAllTab() {
        return false;
    }

    public static class ShowOlder
    extends TabExpanderAction {
        public ShowOlder(SoyTemplateRenderer renderer, Map<String, Object> params) {
            super(renderer, params);
        }

        @Override
        protected String templateName() {
            return "JIRA.Templates.IssueTabPanels.Expanders.showOlderExpander";
        }
    }

    public static class ShowNewer
    extends TabExpanderAction {
        public ShowNewer(SoyTemplateRenderer renderer, Map<String, Object> params) {
            super(renderer, params);
        }

        @Override
        protected String templateName() {
            return "JIRA.Templates.IssueTabPanels.Expanders.showNewerExpander";
        }
    }
}

