/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.CommentSearchParameters;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.issue.tabpanels.WorklogAction;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugin.issuetabpanel.DefaultPage;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.Window;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class WorklogTabPanel
implements PaginatedIssueTabPanel {
    private final WorklogService worklogService;
    private final JiraDurationUtils jiraDurationUtils;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final ApplicationProperties applicationProperties;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final UserFormats userFormats;
    private final DateTimeFormatter formatter;
    protected IssueTabPanelModuleDescriptor descriptor;

    public WorklogTabPanel(WorklogService worklogService, JiraDurationUtils jiraDurationUtils, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager, UserFormats userFormats, DateTimeFormatter formatter) {
        this.worklogService = worklogService;
        this.jiraDurationUtils = jiraDurationUtils;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.applicationProperties = applicationProperties;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.userFormats = userFormats;
        this.formatter = formatter;
    }

    public void init(IssueTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Page<IssueAction> getActions(GetActionsRequest request) {
        Page<IssueAction> worklogs = this.getWorklogs(request);
        if (worklogs.getPageContents().isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nowork"));
            return DefaultPage.only((Collection)Lists.newArrayList((Object[])new IssueAction[]{action}));
        }
        return worklogs;
    }

    private Page<IssueAction> getWorklogs(final GetActionsRequest request) {
        final Window userWorklogs = this.worklogService.getByIssueVisibleToUser(WorklogTabPanel.requestToSearchParameters(request));
        return new Page<IssueAction>(){

            public boolean isFirstPage() {
                return !userWorklogs.hasElementsBefore();
            }

            public boolean isLastPage() {
                return !userWorklogs.hasElementsAfter();
            }

            public List<IssueAction> getPageContents() {
                return WorklogTabPanel.this.convertToActions(userWorklogs.get(), new JiraServiceContextImpl(request.loggedInUser(), (ErrorCollection)new SimpleErrorCollection()));
            }
        };
    }

    private static CommentSearchParameters requestToSearchParameters(GetActionsRequest request) {
        CommentSearchParameters.Builder builder = CommentSearchParameters.builder().issue(request.issue()).user(request.loggedInUser());
        if (request.batching().fromDate() != null) {
            CommentSearchParameters.SearchDirection commentSearchDirection = request.batching().fetchMode() == GetActionsRequest.FetchMode.OLDER_THAN_DATE ? CommentSearchParameters.SearchDirection.OLDER : CommentSearchParameters.SearchDirection.NEWER;
            builder.searchByDate(request.batching().fromDate(), commentSearchDirection);
            if (request.batching().fetchMode() == GetActionsRequest.FetchMode.OLDER_THAN_DATE) {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.OLDER);
            } else {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.NEWER);
            }
        } else if (NumberUtils.isCreatable((String)request.getFocusId())) {
            builder.searchByComment(Long.parseLong(request.getFocusId()), CommentSearchParameters.SearchDirection.BOTH);
            builder.searchByComment(Long.parseLong(request.getFocusId()), CommentSearchParameters.SearchDirection.BOTH);
        } else if (request.batching().fetchMode() == GetActionsRequest.FetchMode.FROM_OLDEST) {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.OLDER);
        } else {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.NEWER);
        }
        if (request.isValidShowAllRequest()) {
            builder.noLimit();
        } else {
            builder.limit(request.batching().limit());
        }
        return builder.build();
    }

    private List<IssueAction> convertToActions(List<Worklog> worklogs, JiraServiceContextImpl context) {
        ArrayList actions = Lists.newArrayListWithCapacity((int)worklogs.size());
        for (Worklog userWorklog : worklogs) {
            boolean canEditWorklog = this.worklogService.hasPermissionToUpdate((JiraServiceContext)context, userWorklog);
            boolean canDeleteWorklog = this.worklogService.hasPermissionToDelete((JiraServiceContext)context, userWorklog);
            actions.add(new WorklogAction(this.descriptor, userWorklog, this.jiraDurationUtils, canEditWorklog, canDeleteWorklog, this.fieldLayoutManager, this.rendererManager, context.getI18nBean().getLocale(), this.userFormats, this.formatter));
        }
        return actions;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", request.issue());
    }
}

