/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.thumbnail;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.core.util.thumbnail.ThumbnailUtil;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.config.util.ThumbnailConfiguration;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.thumbnail.AtlassianCoreThumbnail;
import com.atlassian.jira.issue.thumbnail.BrokenThumbnail;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Promise;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThumbnailManager
implements ThumbnailManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultThumbnailManager.class);
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private final AttachmentKeyMapper attachmentKeyMapper;
    private final AttachmentManager attachmentManager;
    private final ThumbnailAccessor thumbnailAccessor;
    private final MimeManager mimeManager;
    private final ThumbnailConfiguration thumbnailConfig;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final FeatureManager featureManager;
    private final StreamAttachmentStore streamAttachmentStore;
    private final AttachmentConfigManager attachmentConfigManager;
    private final boolean toolkitAvailable;

    public DefaultThumbnailManager(AttachmentKeyMapper attachmentKeyMapper, ThumbnailConfiguration thumbnailConfiguration, AttachmentManager attachmentManager, MimeManager mimeManager, VelocityRequestContextFactory velocityRequestContextFactory, ThumbnailAccessor thumbnailAccessor, ApplicationProperties applicationProperties, FeatureManager featureManager, StreamAttachmentStore streamAttachmentStore, AttachmentConfigManager attachmentConfigManager) {
        this.attachmentKeyMapper = Objects.requireNonNull(attachmentKeyMapper);
        this.attachmentManager = attachmentManager;
        this.thumbnailAccessor = thumbnailAccessor;
        this.mimeManager = mimeManager;
        this.thumbnailConfig = thumbnailConfiguration;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
        this.toolkitAvailable = Toolkit.getDefaultToolkit() != null;
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
    }

    public Collection<Thumbnail> getThumbnails(Issue issue, ApplicationUser user) {
        List attachments = this.attachmentManager.getAttachments(issue);
        ArrayList thumbnails = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Attachment attachment : attachments) {
            if (!this.isThumbnailable(issue, attachment)) continue;
            thumbnails.add(this.doGetThumbnail(issue, attachment));
        }
        return thumbnails;
    }

    public boolean isThumbnailable(Issue issue, Attachment attachment) {
        if (attachment.isThumbnailable() != null) {
            return attachment.isThumbnailable();
        }
        if (!this.checkToolkit()) {
            return false;
        }
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        Promise isSupportedImage = this.streamAttachmentStore.getAttachment(attachmentKey, input -> new Thumber(MIME_TYPE).isFileSupportedImage(input)).recover(t -> false);
        boolean thumbnailable = false;
        if (((Boolean)isSupportedImage.claim()).booleanValue()) {
            String mimeType = this.mimeManager.getSuggestedMimeType(attachment.getFilename());
            thumbnailable = ThumbnailUtil.isMimeTypeSupported((String)mimeType);
        }
        this.attachmentManager.setThumbnailable(attachment, thumbnailable);
        return thumbnailable;
    }

    public boolean isThumbnailable(Attachment attachment) {
        return this.isThumbnailable(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Attachment attachment) {
        return this.getThumbnail(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Issue issue, Attachment attachment) {
        if (!this.isThumbnailable(issue, attachment)) {
            return null;
        }
        return this.doGetThumbnail(issue, attachment);
    }

    @Nullable
    public Thumbnail getThumbnailDeferred(Issue issue, Attachment attachment) {
        if (!this.isThumbnailable(issue, attachment)) {
            return null;
        }
        return this.doGetThumbnail(issue, attachment, this.featureManager.isEnabled(JiraFeatureFlagRegistrar.THUMBNAILS_DEFERRED_GENERATION_ALLOWED));
    }

    public boolean checkToolkit() {
        return this.toolkitAvailable;
    }

    public ThumbnailedImage toThumbnailedImage(@Nullable Thumbnail thumbnail) {
        if (thumbnail == null) {
            return null;
        }
        return new AtlassianCoreThumbnail(this.applicationProperties, this.velocityRequestContextFactory.getJiraVelocityRequestContext(), thumbnail);
    }

    /*
     * Exception decompiling
     */
    public <T> T streamThumbnailContent(Attachment attachment, InputStreamConsumer<T> consumer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Thumbnail doGetThumbnail(Issue issue, Attachment attachment) {
        return this.doGetThumbnail(issue, attachment, this.featureManager.isEnabled(JiraFeatureFlagRegistrar.THUMBNAILS_DEFERRED_GENERATION_ALLOWED) && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ALL_THUMBNAILS_DEFERRED));
    }

    private Thumbnail doGetThumbnail(Issue issue, Attachment attachment, boolean deferred) {
        FileStore.Path thumbnailPath = this.getThumbnailFile(issue, attachment);
        return thumbnailPath.getLeafName().map(thumbnailName -> this.doGetThumbnail(attachment, thumbnailPath, (String)thumbnailName, deferred)).orElseGet(() -> {
            log.debug("No thumbnail file name found for {} ", (Object)thumbnailPath);
            return new BrokenThumbnail(attachment.getId());
        });
    }

    private Thumbnail doGetThumbnail(Attachment attachment, FileStore.Path thumbnailPath, String thumbnailName, boolean deferred) {
        if (deferred) {
            return new Thumbnail(this.thumbnailConfig.getMaxWidth(), this.thumbnailConfig.getMaxHeight(), thumbnailName, attachment.getId().longValue(), MIME_TYPE);
        }
        Thumbnail existingThumbnail = this.readThumbnail(attachment, thumbnailPath, thumbnailName);
        if (existingThumbnail != null) {
            return existingThumbnail;
        }
        return this.generateThumbnail(attachment, thumbnailPath, thumbnailName);
    }

    private Thumbnail generateThumbnail(Attachment attachment, FileStore.Path thumbnailPath) {
        return thumbnailPath.getLeafName().map(thumbnailName -> this.generateThumbnail(attachment, thumbnailPath, (String)thumbnailName)).orElseGet(() -> {
            log.debug("No thumbnail file name found for {} ", (Object)thumbnailPath);
            return new BrokenThumbnail(attachment.getId());
        });
    }

    private Thumbnail generateThumbnail(Attachment attachment, FileStore.Path thumbnailPath, String thumbnailName) {
        File tempThumbnailFile = this.getTempFile(thumbnailName);
        int scalingFactor = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.thumbnails.scaling.factor"));
        Thumbnail thumbnail = this.createThumbnail(attachment, tempThumbnailFile, this.thumbnailConfig.getMaxWidth(), this.thumbnailConfig.getMaxHeight(), scalingFactor);
        if (thumbnail instanceof BrokenThumbnail) {
            return thumbnail;
        }
        if (thumbnailPath.tryFileExists()) {
            FileUtils.deleteQuietly((File)tempThumbnailFile);
        } else {
            FilesystemPath fileStorePath = FilesystemFileStore.forFile((File)tempThumbnailFile);
            try {
                fileStorePath.moveFile(thumbnailPath);
            }
            catch (IOException e) {
                log.debug("Could not move '{}' to '{}'", (Object)tempThumbnailFile.getAbsolutePath(), (Object)thumbnailPath);
                FileUtils.deleteQuietly((File)tempThumbnailFile);
                return new BrokenThumbnail(attachment.getId());
            }
        }
        return new Thumbnail(thumbnail.getHeight(), thumbnail.getWidth(), thumbnailName, attachment.getId().longValue(), thumbnail.getMimeType());
    }

    private FileStore.Path getThumbnailFile(@Nullable Issue issue, Attachment attachment) {
        return issue == null ? this.thumbnailAccessor.getThumbnailFilePath(attachment) : this.thumbnailAccessor.getThumbnailFilePath(issue, attachment);
    }

    private Thumbnail createThumbnail(Attachment attachment, File thumbnailFile, int maxWidth, int maxHeight, int scalingFactor) {
        try {
            FileUtils.touch((File)thumbnailFile);
            FileUtils.deleteQuietly((File)thumbnailFile);
            return (Thumbnail)this.attachmentManager.streamAttachmentContent(attachment, in -> {
                Thumbnail thumbnail = new Thumber(MIME_TYPE, scalingFactor).retrieveOrCreateThumbNail(in, attachment.getFilename(), thumbnailFile, maxWidth, maxHeight, attachment.getId().longValue());
                if (thumbnail == null) {
                    return null;
                }
                if (thumbnail.getFilename() != null && thumbnailFile.getName().equals(thumbnail.getFilename())) {
                    return thumbnail;
                }
                return new Thumbnail(thumbnail.getHeight(), thumbnail.getWidth(), thumbnailFile.getName(), thumbnail.getAttachmentId(), thumbnail.getMimeType());
            });
        }
        catch (NoAttachmentDataException noAttachmentDataException) {
            log.warn("Unable to create thumbnail {} for image {} id: {}, found in issue {}.", new Object[]{thumbnailFile.getAbsolutePath(), attachment.getFilename(), attachment.getId(), attachment.getIssue().getKey(), noAttachmentDataException});
            return new BrokenThumbnail(attachment.getId());
        }
        catch (Exception e) {
            log.warn("Unable to create thumbnail {} for image {} id: {}, found in issue {}. Resetting thumbnailable flag to FALSE ", new Object[]{thumbnailFile.getAbsolutePath(), attachment.getFilename(), attachment.getId(), attachment.getIssue().getKey(), e});
            this.attachmentManager.setThumbnailable(attachment, false);
            return new BrokenThumbnail(attachment.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thumbnail readThumbnail(@Nonnull Attachment attachment, @Nonnull FileStore.Path thumbnailPath, @Nonnull String thumbnailName) {
        if (thumbnailPath.tryFileExists()) {
            log.debug("Thumbnail file '{}' already exists. Returning existing thumbnail.", (Object)thumbnailPath);
            InputStream inputStream = null;
            try {
                inputStream = thumbnailPath.fileReader().openInputStream();
                ThumbnailDimension thumbnailDimension = ThumbnailUtil.dimensionsForImage((InputStream)inputStream);
                Thumbnail thumbnail = new Thumbnail(thumbnailDimension.getHeight(), thumbnailDimension.getWidth(), thumbnailName, attachment.getId().longValue(), MIME_TYPE);
                return thumbnail;
            }
            catch (IOException asd) {
                log.debug("Unable to read image data from existing thumbnail file '{}'. Deleting this thumbnail.", (Object)thumbnailPath);
                thumbnailPath.tryDeleteFile();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return null;
    }

    public void deleteThumbnailForAttachment(@Nullable Issue issue, Attachment attachment) {
        FileStore.Path thumbnailPath;
        if (this.isThumbnailable(issue, attachment) && (thumbnailPath = this.getThumbnailFile(issue, attachment)).tryFileExists() && !thumbnailPath.tryDeleteFile()) {
            log.debug("Unable to delete thumbnail for attachment {}", (Object)attachment.getId());
        }
    }

    public void deleteThumbnailsForIssue(@Nonnull Issue issue) {
        for (Attachment attachment : this.attachmentManager.getAttachments(issue)) {
            this.deleteThumbnailForAttachment(issue, attachment);
        }
        this.thumbnailAccessor.deleteThumbnailDirectory(issue).fail(exception -> log.debug("Unable to delete thumbnail directory of issue {}", (Object)issue.getKey(), exception));
    }

    private File getTempFile(String thumbnailName) {
        try {
            return File.createTempFile(thumbnailName, TEMP_FILE_SUFFIX, this.attachmentConfigManager.getTemporaryAttachmentDirectory());
        }
        catch (IOException unableToCreateFile) {
            throw new IllegalStateException(unableToCreateFile);
        }
    }
}

