/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util.streamingretrievers;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslUtils;
import com.atlassian.jira.issue.util.streamingretrievers.BaseStreamingRetriever;
import com.atlassian.jira.model.querydsl.ChangeItemDTO;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class StreamingChangeItemDTORetriever
extends BaseStreamingRetriever<Long, String, ChangeItemDTO> {
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseAccessor dbAccessor;

    public StreamingChangeItemDTORetriever(QueryDslAccessor queryDslAccessor, DatabaseAccessor dbAccessor) {
        this.queryDslAccessor = queryDslAccessor;
        this.dbAccessor = dbAccessor;
    }

    @Override
    protected List<Long> getEntityIds(String queryParam) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)((SQLQuery)c.newSqlQuery().select(QChangeItem.CHANGE_ITEM.id).from((Expression)QChangeItem.CHANGE_ITEM)).where((Predicate)StreamingChangeItemDTORetriever.getWhereClause(this.dbAccessor.getDatabaseVendor(), queryParam))).orderBy(QChangeItem.CHANGE_ITEM.id.asc())).fetch());
    }

    public static BooleanExpression getWhereClause(DatabaseVendor dbVendor, String queryParam) {
        return Expressions.allOf((BooleanExpression[])new BooleanExpression[]{QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"jira"), QChangeItem.CHANGE_ITEM.field.in((Object[])new String[]{"summary", "description", "environment"}), QueryDslUtils.safeContainsIgnoreCase(dbVendor, QChangeItem.CHANGE_ITEM.oldstring, queryParam).or((Predicate)QueryDslUtils.safeContainsIgnoreCase(dbVendor, QChangeItem.CHANGE_ITEM.newstring, queryParam))});
    }

    @Override
    protected List<ChangeItemDTO> getEntitiesBatchByIds(List<Long> idsBatch) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)c.newSqlQuery().select((Expression)QChangeItem.CHANGE_ITEM).from((Expression)QChangeItem.CHANGE_ITEM)).where((Predicate)QChangeItem.CHANGE_ITEM.id.in((Collection)idsBatch))).fetch());
    }
}

