/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.ValueBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DefaultValueBuilder
implements ValueBuilder {
    private final JqlClauseBuilder builder;
    private final String clauseName;
    private final Operator operator;

    DefaultValueBuilder(JqlClauseBuilder builder, String clauseName, Operator operator) {
        this.builder = (JqlClauseBuilder)Assertions.notNull((String)"builder", (Object)builder);
        this.clauseName = (String)Assertions.notNull((String)"clauseName", (Object)clauseName);
        this.operator = (Operator)Assertions.notNull((String)"operator", (Object)operator);
    }

    public JqlClauseBuilder string(String value) {
        return this.builder.addStringCondition(this.clauseName, this.operator, value);
    }

    public JqlClauseBuilder strings(String ... values) {
        return this.builder.addStringCondition(this.clauseName, this.operator, values);
    }

    public JqlClauseBuilder strings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, this.operator, values);
    }

    public JqlClauseBuilder number(Long value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    public JqlClauseBuilder numbers(Long ... value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    public JqlClauseBuilder numbers(Collection<Long> value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    public JqlClauseBuilder operand(Operand operand) {
        return this.builder.addCondition(this.clauseName, this.operator, operand);
    }

    public JqlClauseBuilder operands(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, this.operator, operands);
    }

    public JqlClauseBuilder operands(Collection<? extends Operand> operands) {
        return this.builder.addCondition(this.clauseName, this.operator, operands);
    }

    public JqlClauseBuilder empty() {
        return this.builder.addCondition(this.clauseName, this.operator, (Operand)EmptyOperand.EMPTY);
    }

    public JqlClauseBuilder function(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName);
    }

    public JqlClauseBuilder function(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName, args);
    }

    public JqlClauseBuilder function(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName, args);
    }

    public JqlClauseBuilder functionStandardIssueTypes() {
        return this.function("standardIssueTypes");
    }

    public JqlClauseBuilder functionSubTaskIssueTypes() {
        return this.function("subTaskIssueTypes");
    }

    public JqlClauseBuilder functionMembersOf(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        return this.function("membersOf", groupName);
    }

    public JqlClauseBuilder functionCurrentUser() {
        return this.function("currentUser");
    }

    public JqlClauseBuilder functionIssueHistory() {
        return this.function("issueHistory");
    }

    public JqlClauseBuilder functionReleasedVersions(String ... projects) {
        return this.function("releasedVersions", projects);
    }

    public JqlClauseBuilder functionUnreleasedVersions(String ... projects) {
        return this.function("unreleasedVersions", projects);
    }

    public JqlClauseBuilder functionNow() {
        return this.function("now");
    }

    public JqlClauseBuilder functionWatchedIssues() {
        return this.function("watchedIssues");
    }

    public JqlClauseBuilder functionVotedIssues() {
        return this.function("votedIssues");
    }

    public JqlClauseBuilder functionLinkedIssues(String issue, String ... issueLinkTypes) {
        List<String> args;
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"issueLinkTypes", (Object)issueLinkTypes);
        if (issueLinkTypes.length == 0) {
            args = Collections.singletonList(issue);
        } else {
            args = new ArrayList<String>(issueLinkTypes.length + 1);
            args.add(issue);
            args.addAll(Arrays.asList(issueLinkTypes));
        }
        return this.function("linkedIssues", args);
    }

    public JqlClauseBuilder functionUpdatedBy(String user) {
        Assertions.notNull((String)"user", (Object)user);
        List<String> args = Collections.singletonList(user);
        return this.function("updatedBy", args);
    }

    public JqlClauseBuilder functionRemoteLinksByGlobalId(String ... globalIds) {
        Assertions.notNull((String)"globalIds", (Object)globalIds);
        Assertions.stateFalse((String)"empty globalIds", (globalIds.length == 0 ? 1 : 0) != 0);
        return this.function("issuesWithRemoteLinksByGlobalId", globalIds);
    }

    public JqlClauseBuilder functionCascaingOption(String parent) {
        return this.function("cascadeOption", parent);
    }

    public JqlClauseBuilder functionCascaingOption(String parent, String child) {
        return this.function("cascadeOption", parent, child);
    }

    public JqlClauseBuilder functionCascaingOptionParentOnly(String parent) {
        return this.function("cascadeOption", parent, "\"none\"");
    }

    public JqlClauseBuilder functionLastLogin() {
        return this.function("lastLogin");
    }

    public JqlClauseBuilder functionCurrentLogin() {
        return this.function("currentLogin");
    }

    public JqlClauseBuilder date(Date date) {
        return this.builder.addDateCondition(this.clauseName, this.operator, date);
    }

    public JqlClauseBuilder dates(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, this.operator, dates);
    }

    public JqlClauseBuilder dates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, this.operator, dates);
    }
}

