/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.clause;

import com.atlassian.jira.jql.clause.SimpleOperandComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import java.util.LinkedList;
import java.util.List;

public class SimpleEquivalenceComparator {
    public boolean isEquivalent(Clause clause, Clause clause1) {
        Assertions.notNull((String)"clause", (Object)clause);
        Assertions.notNull((String)"clause1", (Object)clause1);
        if (clause.equals(clause1)) {
            return true;
        }
        if (clause instanceof NotClause && clause1 instanceof NotClause) {
            return this.compareNot((NotClause)clause, (NotClause)clause1);
        }
        if (clause instanceof AndClause && clause1 instanceof AndClause) {
            return this.compareMulti((MultiClause)((AndClause)clause), (MultiClause)((AndClause)clause1));
        }
        if (clause instanceof OrClause && clause1 instanceof OrClause) {
            return this.compareMulti((MultiClause)((OrClause)clause), (MultiClause)((OrClause)clause1));
        }
        if (clause instanceof TerminalClause && clause1 instanceof TerminalClause) {
            return this.compareTerminal((TerminalClause)clause, (TerminalClause)clause1);
        }
        return false;
    }

    private boolean compareTerminal(TerminalClause terminalClause, TerminalClause terminalClause1) {
        if (!terminalClause.getName().equals(terminalClause1.getName())) {
            return false;
        }
        if (!terminalClause.getOperator().equals((Object)terminalClause1.getOperator())) {
            return false;
        }
        return new SimpleOperandComparator().isEquivalent(terminalClause.getOperand(), terminalClause1.getOperand());
    }

    private boolean compareNot(NotClause notClause, NotClause notClause1) {
        return this.isEquivalent(notClause.getSubClause(), notClause1.getSubClause());
    }

    private boolean compareMulti(MultiClause clause, MultiClause clause1) {
        List children = clause.getClauses();
        LinkedList children1 = new LinkedList(clause1.getClauses());
        if (children.size() != children1.size()) {
            return false;
        }
        for (Clause child : children) {
            boolean found = false;
            for (Clause child1 : children1) {
                if (!this.isEquivalent(child, child1)) continue;
                found = true;
                children1.remove(child1);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

