/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AllTextCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

@InjectableComponent
public class AllTextClauseContextFactory
implements ClauseContextFactory {
    private final CustomFieldManager customFieldManager;
    private final SearchHandlerManager searchHandlerManager;
    private final ContextSetUtil contextSetUtil;

    public AllTextClauseContextFactory(CustomFieldManager customFieldManager, SearchHandlerManager searchHandlerManager, ContextSetUtil contextSetUtil) {
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((String)"customFieldManager", (Object)customFieldManager);
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.contextSetUtil = (ContextSetUtil)Assertions.notNull((String)"contextSetUtil", (Object)contextSetUtil);
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        List<ClauseContextFactory> clauseContextFactories = this.getFactories(searcher);
        LinkedHashSet<ClauseContext> contexts = new LinkedHashSet<ClauseContext>();
        for (ClauseContextFactory factory : clauseContextFactories) {
            contexts.add(factory.getClauseContext(searcher, terminalClause));
        }
        return this.contextSetUtil.union(contexts);
    }

    List<ClauseContextFactory> getFactories(ApplicationUser searcher) {
        CollectionBuilder factoryCollectionBuilder = CollectionBuilder.newBuilder();
        factoryCollectionBuilder.addAll(this.getAllSystemFieldFactories(searcher));
        factoryCollectionBuilder.addAll(this.getAllCustomFieldFactories(searcher));
        return factoryCollectionBuilder.asList();
    }

    List<ClauseContextFactory> getAllSystemFieldFactories(ApplicationUser searcher) {
        List systemFieldClauseNames = CollectionBuilder.newBuilder((Object[])new String[]{SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName()}).asList();
        ArrayList factories = Lists.newArrayListWithCapacity((int)systemFieldClauseNames.size());
        for (String clauseName : systemFieldClauseNames) {
            Collection handlers = this.searchHandlerManager.getClauseHandler(searcher, clauseName);
            for (ClauseHandler handler : handlers) {
                factories.add(handler.getClauseContextFactory());
            }
        }
        return factories;
    }

    List<ClauseContextFactory> getAllCustomFieldFactories(ApplicationUser user) {
        List allCustomFields = this.customFieldManager.getCustomFieldObjects();
        ArrayList factories = Lists.newArrayListWithCapacity((int)allCustomFields.size());
        for (CustomField customField : allCustomFields) {
            CustomFieldSearcherClauseHandler fieldSearcherClauseHandler;
            CustomFieldSearcher searcher = customField.getCustomFieldSearcher();
            if (searcher == null || (fieldSearcherClauseHandler = searcher.getCustomFieldSearcherClauseHandler()) == null || !fieldSearcherClauseHandler.getSupportedOperators().contains(Operator.LIKE) || !(fieldSearcherClauseHandler instanceof AllTextCustomFieldSearcherClauseHandler)) continue;
            Collection handlers = this.searchHandlerManager.getClauseHandler(user, customField.getClauseNames().getPrimaryName());
            for (ClauseHandler handler : handlers) {
                factories.add(handler.getClauseContextFactory());
            }
        }
        return factories;
    }
}

