/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ComponentIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ComponentClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<ProjectComponent> {
    private final JqlOperandResolver jqlOperandResolver;
    private final ComponentResolver componentResolver;
    private final ProjectManager projectManager;

    public ComponentClauseContextFactory(JqlOperandResolver jqlOperandResolver, ComponentResolver componentResolver, ProjectManager projectManager, PermissionManager permissionManager) {
        super((IndexInfoResolver)new ComponentIndexInfoResolver(componentResolver), jqlOperandResolver, permissionManager);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
        this.componentResolver = (ComponentResolver)Assertions.notNull((String)"componentResolver", (Object)componentResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
    }

    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        ArrayList specifiedComponents;
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        ArrayList arrayList = specifiedComponents = literals != null ? Lists.newArrayListWithCapacity((int)literals.size()) : Lists.newArrayList();
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) continue;
                List ids = this.getIds(literal);
                for (Long id : ids) {
                    specifiedComponents.add(this.componentResolver.get(id));
                }
            }
        }
        if (!specifiedComponents.isEmpty()) {
            ArrayList contextComponents = new ArrayList();
            if (this.isNegationOperator(operator)) {
                ArrayList<ProjectComponent> allComponents = new ArrayList<ProjectComponent>(this.componentResolver.getAll());
                allComponents.removeAll(specifiedComponents);
                contextComponents.addAll(allComponents);
            } else {
                contextComponents = specifiedComponents;
            }
            HashSet contexts = new HashSet();
            for (ProjectComponent contextComponent : contextComponents) {
                contexts.addAll(this.getContextsForProject(searcher, this.getProject(contextComponent.getProjectId())));
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private Project getProject(Long projectId) {
        return this.projectManager.getProjectObj(projectId);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }
}

