/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class FunctionOperandHandler
implements OperandHandler<FunctionOperand> {
    protected final I18nHelper i18nHelper;
    protected final JqlFunction jqlFunction;

    public FunctionOperandHandler(JqlFunction jqlFunction, I18nHelper i18nHelper) {
        this.jqlFunction = (JqlFunction)Assertions.notNull((String)"jqlFunction", (Object)jqlFunction);
        this.i18nHelper = i18nHelper;
    }

    @Override
    public MessageSet validate(final ApplicationUser searcher, final FunctionOperand operand, final TerminalClause terminalClause) {
        return (MessageSet)SafePluginPointAccess.call((Callable)new Callable<MessageSet>(){

            @Override
            public MessageSet call() throws Exception {
                return FunctionOperandHandler.this.jqlFunction.validate(searcher, operand, terminalClause);
            }
        }).getOrElse((java.util.function.Supplier)new Supplier<MessageSet>(){

            public MessageSet get() {
                String functionName = (String)SafePluginPointAccess.call((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return FunctionOperandHandler.this.jqlFunction.getFunctionName();
                    }
                }).getOrNull();
                MessageSetImpl messageSet = new MessageSetImpl();
                messageSet.addErrorMessage(FunctionOperandHandler.this.i18nHelper.getText("jira.jql.operand.cannot.validate.function", functionName));
                return messageSet;
            }
        });
    }

    @Override
    public List<QueryLiteral> getValues(final QueryCreationContext queryCreationContext, final FunctionOperand operand, final TerminalClause terminalClause) {
        return (List)SafePluginPointAccess.call((Callable)new Callable<List<QueryLiteral>>(){

            @Override
            public List<QueryLiteral> call() throws Exception {
                return FunctionOperandHandler.this.jqlFunction.getValues(queryCreationContext, operand, terminalClause);
            }
        }).getOrElse(Collections.emptyList());
    }

    @Override
    public boolean isList() {
        return (Boolean)SafePluginPointAccess.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return FunctionOperandHandler.this.jqlFunction.isList();
            }
        }).getOrElse((Object)false);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    public JqlFunction getJqlFunction() {
        return this.jqlFunction;
    }
}

