/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Set;

@NonInjectableComponent
public class FieldClausePermissionChecker
implements ClausePermissionChecker {
    private final FieldManager fieldManager;
    private final Field field;

    public FieldClausePermissionChecker(Field field, FieldManager fieldManager) {
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.field = (Field)Assertions.notNull((String)"field", (Object)field);
    }

    public boolean hasPermissionToUseClause(ApplicationUser user) {
        return !this.fieldManager.isFieldHidden(user, this.field);
    }

    public boolean hasPermissionToUseClause(ApplicationUser searcher, Set<FieldLayout> fieldLayouts) {
        return !this.fieldManager.isFieldHidden(fieldLayouts, this.field);
    }

    public static final class DefaultFactory
    implements Factory {
        @Override
        public ClausePermissionChecker createPermissionChecker(Field field) {
            return new FieldClausePermissionChecker(field, DefaultFactory.getFieldManager());
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(String fieldId) {
            Field field = DefaultFactory.getFieldManager().getField(fieldId);
            return new FieldClausePermissionChecker(field, DefaultFactory.getFieldManager());
        }

        private static FieldManager getFieldManager() {
            return ComponentAccessor.getFieldManager();
        }
    }

    @InjectableComponent
    public static interface Factory {
        public ClausePermissionChecker createPermissionChecker(Field var1);

        public ClausePermissionChecker createPermissionChecker(String var1);
    }
}

