/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.AbstractPropertyClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Set;

public class AliasedIssuePropertyClauseQueryFactory
extends AbstractPropertyClauseQueryFactory {
    private final Property property;
    private final IndexDocumentConfiguration.Type type;
    private final Set<Operator> operators;

    public AliasedIssuePropertyClauseQueryFactory(DoubleConverter doubleConverter, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext, Property property, IndexDocumentConfiguration.Type type, Set<Operator> operators) {
        super(doubleConverter, jqlDateSupport, operandResolver, authenticationContext);
        this.property = (Property)Preconditions.checkNotNull((Object)property);
        this.type = (IndexDocumentConfiguration.Type)Preconditions.checkNotNull((Object)type);
        this.operators = (Set)Preconditions.checkNotNull(operators);
    }

    @Override
    protected boolean isSupportedOperator(TerminalClause terminalClause) {
        return this.operators.contains(terminalClause.getOperator());
    }

    @Override
    protected Option<Property> getProperty(TerminalClause terminalClause) {
        return Option.some((Object)this.property);
    }

    @Override
    protected Iterable<IndexDocumentConfiguration.Type> getPropertyTypes(Property property) {
        return ImmutableSet.of((Object)this.type);
    }
}

