/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ChangeHistoryFieldIdResolver;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.util.DateRange;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.history.AndHistoryPredicate;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class HistoryPredicateQueryFactory {
    private final PredicateOperandResolver predicateOperandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final UserResolver userResolver;
    private final ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver;
    private static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    private static final Date MIN_DATE = new Date(0L);
    private static final Query FALSE_QUERY = new BooleanQuery.Builder().build();

    @Deprecated
    public HistoryPredicateQueryFactory(PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver) {
        this(predicateOperandResolver, jqlDateSupport, (UserResolver)ComponentAccessor.getComponentOfType(UserResolver.class), changeHistoryFieldIdResolver);
    }

    public HistoryPredicateQueryFactory(PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, UserResolver userResolver, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver) {
        this.predicateOperandResolver = predicateOperandResolver;
        this.jqlDateSupport = jqlDateSupport;
        this.userResolver = userResolver;
        this.changeHistoryFieldIdResolver = changeHistoryFieldIdResolver;
    }

    public BooleanQuery makePredicateQuery(ApplicationUser searcher, String field, HistoryPredicate historyPredicate, boolean isChangedSearch) {
        BooleanQuery.Builder predicateQuery = new BooleanQuery.Builder();
        ArrayList<TerminalHistoryPredicate> terminalPredicates = new ArrayList<TerminalHistoryPredicate>();
        if (historyPredicate instanceof AndHistoryPredicate) {
            for (HistoryPredicate historyPredicate2 : ((AndHistoryPredicate)historyPredicate).getPredicates()) {
                terminalPredicates.add((TerminalHistoryPredicate)historyPredicate2);
            }
        } else {
            terminalPredicates.add((TerminalHistoryPredicate)historyPredicate);
        }
        for (TerminalHistoryPredicate terminalHistoryPredicate : terminalPredicates) {
            this.makeBooleanQuery(searcher, field, terminalHistoryPredicate, predicateQuery, isChangedSearch);
        }
        return predicateQuery.build();
    }

    private void makeBooleanQuery(ApplicationUser searcher, String field, TerminalHistoryPredicate predicate, BooleanQuery.Builder predicateQuery, boolean isChangedSearch) {
        Assertions.notNull((String)"Must provide a predicate", (Object)predicate);
        Assertions.notNull((String)"must provide a predicateQuery", (Object)predicateQuery);
        Operator operator = predicate.getOperator();
        Operand operand = predicate.getOperand();
        List<QueryLiteral> operandValues = this.getValuesForOperatorAndOperand(searcher, field, operator, operand);
        if (operandValues == null || operandValues.isEmpty()) {
            return;
        }
        if (Operator.BY.equals((Object)operator)) {
            this.makeBYQuery(predicateQuery, operandValues);
        }
        if (Operator.TO.equals((Object)operator)) {
            this.makeChangedQuery(field, predicateQuery, operandValues, true);
        }
        if (Operator.FROM.equals((Object)operator)) {
            this.makeChangedQuery(field, predicateQuery, operandValues, false);
        }
        if (OperatorClasses.CHANGE_HISTORY_DATE_PREDICATES.contains(operator)) {
            if (Operator.DURING.equals((Object)operator)) {
                this.makeDURINGQuery(predicateQuery, operandValues, field, isChangedSearch);
            } else if (Operator.ON.equals((Object)operator)) {
                this.makeONQuery(predicateQuery, operandValues, field, isChangedSearch);
            } else {
                this.makeBEFOREorAFTERQuery(operator, predicateQuery, operandValues, field, isChangedSearch);
            }
        }
    }

    private void makeChangedQuery(String fieldName, BooleanQuery.Builder predicateQuery, List<QueryLiteral> operandValues, boolean isUpperBounds) {
        BooleanQuery.Builder changedQuery = new BooleanQuery.Builder();
        for (QueryLiteral literal : operandValues) {
            Collection ids = this.changeHistoryFieldIdResolver.resolveIdsForField(fieldName, literal, literal.isEmpty());
            if (ids == null || ids.isEmpty()) {
                String value = literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue();
                String documentField = isUpperBounds ? "ch_to" : "ch_from";
                changedQuery.add((Query)this.createTermQuery(fieldName, documentField, HistoryPredicateQueryFactory.encodeProtocol(value)), BooleanClause.Occur.SHOULD);
                continue;
            }
            for (String id : ids) {
                String documentField = isUpperBounds ? "ch_newvalue" : "ch_oldvalue";
                changedQuery.add((Query)this.createTermQuery(fieldName, documentField, HistoryPredicateQueryFactory.encodeProtocolPreservingCase(id)), BooleanClause.Occur.SHOULD);
            }
        }
        predicateQuery.add((Query)changedQuery.build(), BooleanClause.Occur.MUST);
    }

    private TermQuery createTermQuery(String fieldName, String documentField, String value) {
        return new TermQuery(new Term(fieldName.toLowerCase() + '.' + documentField, value));
    }

    private void makeBYQuery(BooleanQuery.Builder predicateQuery, List<QueryLiteral> operandValues) {
        BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
        for (QueryLiteral literal : operandValues) {
            String userName = literal.getLongValue() == null ? literal.getStringValue() : literal.getLongValue().toString();
            for (String userKey : this.userResolver.getIdsFromName(userName)) {
                userQuery.add((Query)new TermQuery(new Term("ch_who", HistoryPredicateQueryFactory.encodeProtocolPreservingCase(userKey))), BooleanClause.Occur.SHOULD);
            }
        }
        predicateQuery.add((Query)userQuery.build(), BooleanClause.Occur.MUST);
    }

    private void makeDURINGQuery(BooleanQuery.Builder predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        if (operandValues.size() < 2) {
            predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
        } else {
            DateRange bottomBoundDateRange = this.convertToDateRangeWithImpliedPrecision(operandValues.get(0));
            DateRange upperBoundDateRange = this.convertToDateRangeWithImpliedPrecision(operandValues.get(1));
            if (bottomBoundDateRange == null || upperBoundDateRange == null) {
                predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
            } else {
                this.makeInclusiveQueryBasedOnDates(predicateQuery, field, bottomBoundDateRange.getLowerDate(), upperBoundDateRange.getUpperDate(), isChangedSearch);
            }
        }
    }

    private void makeONQuery(BooleanQuery.Builder predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (QueryLiteral literal : operandValues) {
            DateRange dateRange = this.convertToDateRangeWithImpliedPrecision(literal);
            if (dateRange == null) {
                query.add(FALSE_QUERY, BooleanClause.Occur.MUST);
                return;
            }
            BooleanQuery.Builder condition = new BooleanQuery.Builder();
            this.makeInclusiveQueryBasedOnDates(condition, field, dateRange.getLowerDate(), dateRange.getUpperDate(), isChangedSearch);
            query.add((Query)condition.build(), BooleanClause.Occur.SHOULD);
        }
        predicateQuery.add((Query)query.build(), BooleanClause.Occur.MUST);
    }

    private Date addOneUnit(Date lowerDate) {
        return DateUtils.addSeconds((Date)lowerDate, (int)1);
    }

    private void makeBEFOREorAFTERQuery(Operator operator, BooleanQuery.Builder predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        QueryLiteral literal = operandValues.get(0);
        DateRange dateRange = this.convertToDateRangeWithImpliedPrecision(literal);
        if (dateRange == null) {
            predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
        } else if (Operator.BEFORE.equals((Object)operator)) {
            this.makeExclusiveQueryBasedOnDates(predicateQuery, field, MIN_DATE, dateRange.getLowerDate(), isChangedSearch);
        } else if (Operator.AFTER.equals((Object)operator)) {
            this.makeExclusiveQueryBasedOnDates(predicateQuery, field, this.addOneUnit(dateRange.getUpperDate()), MAX_DATE, isChangedSearch);
        }
    }

    private void makeExclusiveQueryBasedOnDates(BooleanQuery.Builder bq, String field, Date fromDate, Date toDate, boolean isChangedSearch) {
        this.makeTermQueryImpl(bq, field, fromDate, toDate, false, isChangedSearch);
    }

    private void makeInclusiveQueryBasedOnDates(BooleanQuery.Builder bq, String field, Date fromDate, Date toDate, boolean isChangedSearch) {
        this.makeTermQueryImpl(bq, field, fromDate, toDate, true, isChangedSearch);
    }

    private void makeTermQueryImpl(BooleanQuery.Builder bq, String field, Date fromDate, Date toDate, boolean inclusiveSearch, boolean isChangedSearch) {
        if (fromDate != null && toDate != null) {
            long searchStart = fromDate.getTime() + (inclusiveSearch ? 1000L : 0L);
            long searchEnd = toDate.getTime() - (inclusiveSearch ? 0L : 1000L);
            if (isChangedSearch) {
                bq.add(LongPoint.newRangeQuery((String)"ch_date", (long)searchStart, (long)searchEnd), BooleanClause.Occur.MUST);
            } else {
                bq.add(LongPoint.newRangeQuery((String)(field + "." + "ch_nextchangedate"), (long)searchStart, (long)Long.MAX_VALUE), BooleanClause.Occur.MUST);
                bq.add(LongPoint.newRangeQuery((String)"ch_date", (long)Long.MIN_VALUE, (long)searchEnd), BooleanClause.Occur.MUST);
            }
        }
    }

    private DateRange convertToDateRangeWithImpliedPrecision(QueryLiteral literal) {
        return literal == null ? null : (literal.getLongValue() != null ? this.jqlDateSupport.convertToDateRange(literal.getLongValue()) : this.jqlDateSupport.convertToDateRangeWithImpliedPrecision(literal.getStringValue()));
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }

    private static String encodeProtocolPreservingCase(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem);
    }

    private List<QueryLiteral> getValuesForOperatorAndOperand(ApplicationUser searcher, String field, Operator operator, Operand operand) {
        if (operand instanceof EmptyOperand && Operator.BY.equals((Object)operator)) {
            return Lists.newArrayList((Object[])new QueryLiteral[]{new QueryLiteral(operand, "")});
        }
        return this.predicateOperandResolver.getValues(searcher, field, operand);
    }
}

