/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.SimpleCollector;

public class IssueIdCollector
extends SimpleCollector {
    private Set<String> issueIds = new HashSet<String>();
    private SortedDocValues sortedDocValues;
    private final Integer maxItems;

    public IssueIdCollector() {
        this(Integer.MAX_VALUE);
    }

    public IssueIdCollector(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public void collect(int docId) throws IOException {
        if (this.sortedDocValues.advanceExact(docId)) {
            if (this.issueIds.size() > this.maxItems) {
                throw new CollectionTerminatedException();
            }
            this.issueIds.add(this.sortedDocValues.binaryValue().utf8ToString());
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.sortedDocValues = context.reader().getSortedDocValues("issue_id");
    }

    public Set<String> getIssueIds() {
        return this.issueIds;
    }

    public boolean needsScores() {
        return false;
    }
}

